/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.processManagermant.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.processManagermant.dao.SecurityManageDao;
import com.artfess.cqxy.processManagermant.manager.SecurityManageManager;
import com.artfess.cqxy.processManagermant.model.SecurityManage;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SecurityManageManagerImpl
extends BaseManagerImpl<SecurityManageDao, SecurityManage>
implements SecurityManageManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SystemConfigFeignService scfs;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(SecurityManage entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        String code = this.scfs.getNextIdByAlias("gcgl_aqgl");
        entity.setSecurityInspectCode(code.substring(StringUtils.lastOrdinalIndexOf((CharSequence)code, (CharSequence)"\"", (int)2) + 1, code.lastIndexOf("\"")));
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eleven.getCode());
            ele.setGroup("SecurityManage");
            ele.setNode(ProjectStatusEnum.eleven.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eleven.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, SecurityManage entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        if (null != projectManagement) {
            globalRetrieval.setProjectName(projectManagement.getProjectName());
            globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        }
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.ninteen.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.ninteen.getName());
        globalRetrieval.setBizTableName(FunctionEnum.ninteen.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.ninteen.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.ninteen.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.ninteen.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.ninteen.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.ninteen.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getSecurityInspectCode());
        globalRetrieval.setSearchTitle(entity.getSecurityInspectCode() + "_" + entity.getProjectScale() + "_" + entity.getImageProgress() + "_" + entity.getInspectUserName() + "_" + entity.getBaseSituation() + "_" + entity.getCheckSituation() + "_" + entity.getChangeContractName() + "_" + entity.getReexaminationSituation() + "_" + entity.getReexaminationUser() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public SecurityManage getById(String id) {
        SecurityManage result = ((SecurityManageDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<SecurityManage> queryAllByPage(QueryFilter<SecurityManage> queryFilter) {
        queryFilter.addFilter("bsm.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<SecurityManage> result = ((SecurityManageDao)this.baseMapper).queryAllByPage((IPage<SecurityManage>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<SecurityManage>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (SecurityManage ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, SecurityManage.class, (ImportParams)new ImportParams());
            for (SecurityManage ele : data) {
                ele.setProjectId(projectId);
                String code = this.scfs.getNextIdByAlias("gcgl_aqgl");
                ele.setSecurityInspectCode(code.substring(StringUtils.lastOrdinalIndexOf((CharSequence)code, (CharSequence)"\"", (int)2) + 1, code.lastIndexOf("\"")));
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDataToExcel(QueryFilter<SecurityManage> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u8fc7\u7a0b\u7ba1\u7406-\u5b89\u5168\u7ba1\u7406-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bsm", false);
        List data = ((SecurityManageDao)this.baseMapper).queryAllByPage((IPage<SecurityManage>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<SecurityManage>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, SecurityManage.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

