package com.artfess.cqxy.universal.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Limuhua
 * @date 2022/2/24 17:18
 */
public enum FileTypeEnum {

    one("1", "图片"),

    two("2", "文档"),

    three("3", "压缩文件"),

    four("4", "视频"),

    five("5", "其它");

    FileTypeEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    private String code;
    private String value;

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    public static String getValue(String code){
        if(StringUtils.isEmpty(code)){
            return null;
        }
        FileTypeEnum[] values = values();
        for (FileTypeEnum state : values) {
            if (state.getCode().equals(code)) {
                return state.getValue();
            }
        }
        return null;
    }
}
