package com.artfess.cqxy.contract.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 合同明细表(BizContractItem)表实体类
 *
 * @author 黎沐华
 * @since 2022-02-26 10:34:38
 */
@TableName("BIZ_CONTRACT_ITEM")
@ApiModel(value="合同明细对象-ContractItem", description="合同明细表")
public class Item extends BizModel<Item> {

    // 关联合同的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private Contract contractInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("CONTRACT_ID_")
    @ApiModelProperty(value = "合同ID（关联合同表ID）")
    private String contractId;

    @Excel(name = "序号")
    @TableField("SORT_")
    @ApiModelProperty(value = "序号")
    private Integer sort;

    @Excel(name = "科目编码")
    @TableField("CODE_")
    @ApiModelProperty(value = "科目编码")
    private String code;

    @Excel(name = "科目名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "科目名称")
    private String name;

    @Excel(name = "子科目编码")
    @TableField("SUBJECT_CODE_")
    @ApiModelProperty(value = "子科目编码")
    private String subjectCode;

    @Excel(name = "子科目名称")
    @TableField("SUBJECT_NAME_")
    @ApiModelProperty(value = "子科目名称")
    private String subjectName;

    @Excel(name = "单位")
    @TableField("SPEC_")
    @ApiModelProperty(value = "单位")
    private String spec;

    @Excel(name = "单价（元）", type = 10, numFormat = "0.00")
    @TableField("PRICE_")
    @ApiModelProperty(value = "单价（元）")
    private Double price;

    @Excel(name = "数量", type = 10, numFormat = "0.00")
    @TableField("AMOUNT_")
    @ApiModelProperty(value = "数量（默认值：1）")
    @Value("1")
    private Integer amount;

    @Excel(name = "金额（元）", type = 10, numFormat = "0.00")
    @TableField("MONTY_")
    @ApiModelProperty(value = "金额（元）")
    private Double monty;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Item{" +
                "contractInfo=" + contractInfo +
                ", id='" + id + '\'' +
                ", contractId='" + contractId + '\'' +
                ", sort=" + sort +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", subjectCode='" + subjectCode + '\'' +
                ", subjectName='" + subjectName + '\'' +
                ", spec='" + spec + '\'' +
                ", price=" + price +
                ", amount=" + amount +
                ", monty=" + monty +
                ", remarks='" + remarks + '\'' +
                ", tenantId='" + tenantId + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId_(String id) {
        this.id = id;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId_(String contractId) {
        this.contractId = contractId;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort_(Integer sort) {
        this.sort = sort;
    }

    public String getCode() {
        return code;
    }

    public void setCode_(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName_(String name) {
        this.name = name;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode_(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName_(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec_(String spec) {
        this.spec = spec;
    }

    public Double getPrice() {
        return price;
    }

    public void setPrice_(Double price) {
        this.price = price;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount_(Integer amount) {
        this.amount = amount;
    }

    public Double getMonty() {
        return monty;
    }

    public void setMonty_(Double monty) {
        this.monty = monty;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks_(String remarks) {
        this.remarks = remarks;
    }

    public void setCreateOrgName_(String createOrgName) {
        super.setCreateOrgName(createOrgName);
    }

    public void setCreateCompanyId_(String createCompanyId) {
        super.setCreateCompanyId(createCompanyId);
    }

    public void setCreateCompanyName_(String createCompanyName) {
        super.setCreateCompanyName(createCompanyName);
    }

    public Contract getContractInfo() {
        return contractInfo;
    }

    public void setContractInfo(Contract contractInfo) {
        this.contractInfo = contractInfo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public void setMonty(Double monty) {
        this.monty = monty;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setCreateName_(String createName) {
        super.setCreateName(createName);
    }

    public void setUpdateName_(String updateName) {
        super.setUpdateName(updateName);
    }

    public void setUpdateCompanyName_(String updateCompanyName) {
        super.setUpdateCompanyName(updateCompanyName);
    }

    public void setUpdateCompanyId_(String updateCompanyId) {
        super.setUpdateCompanyId(updateCompanyId);
    }

    public void setUpdateOrgId_(String updateOrgId) {
        super.setUpdateOrgId(updateOrgId);
    }

    public void setUpdateOrgName_(String updateOrgName) {
        super.setUpdateOrgName(updateOrgName);
    }

    public void setLastTime_(Long lastTime) {
        super.setLastTime(lastTime);
    }

    public void setIsDele_(String isDele) {
        super.setIsDele(isDele);
    }

    public void setVersion_(Long version) {
        super.setVersion(version);
    }

    public void setCreateBy_(String createBy) {
        super.setCreateBy(createBy);
    }

    public void setCreateOrgId_(String createOrgId) {
        super.setCreateOrgId(createOrgId);
    }

    public void setCreateTime_(LocalDateTime createTime) {
        super.setCreateTime(createTime);
    }

    public void setUpdateBy_(String updateBy) {
        super.setUpdateBy(updateBy);
    }

    public LocalDateTime getUpdateTime_() {
        return super.getUpdateTime();
    }

    public void setUpdateTime_(LocalDateTime updateTime) {
        super.setUpdateTime(updateTime);
    }

    private String tenantId;

    public void setTenantId_(String tenantId) {
        this.tenantId = tenantId;
    }
}

