package com.artfess.cqxy.completionAcceptance.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 竣工验收 - 决算表(BizAcceptanceFinalAccounts)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-07 15:52:29
 */
@TableName("BIZ_ACCEPTANCE_FINAL_ACCOUNTS")
@ApiModel(value="竣工验收-决算对象-AcceptanceFinalAccounts", description="竣工验收-决算表")
public class AcceptanceFinalAccounts extends BizModel<AcceptanceFinalAccounts> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

//    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的合同信息")
    private Contract contractInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("CONTRACT_ID_")
    @ApiModelProperty(value = "合同ID（关联合同表ID）")
    private String contractId;

    @TableField("CONTRACT_NAME_")
    @ApiModelProperty(value = "合同名称（关联合同表合同名称）")
    private String contractName;

    @Excel(name = "决算单位")
    @TableField("FINAL_ACCOUNTS_OPINIONS_")
    @ApiModelProperty(value = "决算单位")
    private String finalAccountsOpinions;

    @Excel(name = "决算金额(万元)", type = 10, numFormat = "0.00")
    @TableField("FINAL_ACCOUNTS_REGISTRANT_")
    @ApiModelProperty(value = "决算金额（万元）")
    private BigDecimal finalAccountsRegistrant;

    @Excel(name = "审批意见")
    @TableField("APPROVAL_OPINION_")
    @ApiModelProperty(value = "备案机关审批意见")
    private String approvalOpinion;

    @Excel(name = "经办人")
    @TableField("HANDLER_")
    @ApiModelProperty(value = "经办人")
    private String handler;

    @Excel(name = "决算时间",format = "yyyy-MM-dd")
    @TableField("FINAL_ACCOUNTS_DATE_")
    @ApiModelProperty(value = "决算时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finalAccountsDate;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "AcceptanceFinalAccounts{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", contractId='" + contractId + '\'' +
                ", contractName='" + contractName + '\'' +
                ", finalAccountsDate=" + finalAccountsDate +
                ", finalAccountsOpinions='" + finalAccountsOpinions + '\'' +
                ", finalAccountsRegistrant=" + finalAccountsRegistrant +
                ", approvalOpinion='" + approvalOpinion + '\'' +
                ", handler='" + handler + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", contractInfo=" + contractInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

    public String getApprovalOpinion() {
        return approvalOpinion;
    }

    public void setApprovalOpinion(String approvalOpinion) {
        this.approvalOpinion = approvalOpinion;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Date getFinalAccountsDate() {
        return finalAccountsDate;
    }

    public void setFinalAccountsDate(Date finalAccountsDate) {
        this.finalAccountsDate = finalAccountsDate;
    }

    public String getFinalAccountsOpinions() {
        return finalAccountsOpinions;
    }

    public void setFinalAccountsOpinions(String finalAccountsOpinions) {
        this.finalAccountsOpinions = finalAccountsOpinions;
    }

    public BigDecimal getFinalAccountsRegistrant() {
        return finalAccountsRegistrant;
    }

    public void setFinalAccountsRegistrant(BigDecimal finalAccountsRegistrant) {
        this.finalAccountsRegistrant = finalAccountsRegistrant;
    }

    public String getHandler() {
        return handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public ProjectManagement getProjectInfo() {
        return projectInfo;
    }

    public void setProjectInfo(ProjectManagement projectInfo) {
        this.projectInfo = projectInfo;
    }

    public Contract getContractInfo() {
        return contractInfo;
    }

    public void setContractInfo(Contract contractInfo) {
        this.contractInfo = contractInfo;
    }

    public List<Accessory> getAccessoryInfo() {
        return accessoryInfo;
    }

    public void setAccessoryInfo(List<Accessory> accessoryInfo) {
        this.accessoryInfo = accessoryInfo;
    }
}

