package com.artfess.cqxy.universal.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.cqxy.universal.model.Chunk;
import com.artfess.file.util.MinioUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.api.ApiController;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/**
 * 通用附件表(BizAccessory)表控制层
 * @author 黎沐华
 * @since 2022-02-16 17:14:39
 */
@Slf4j
@RestController
@Api(tags = "通用附件管理接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/universal/accessory/v1")
public class AccessoryController extends BaseController<AccessoryManager, Accessory> {

    @PostMapping("/save")
    @ApiOperation(value = "S-批量保存附件信息", httpMethod = "POST")
    public CommonResult<String> saveAccessory(@ApiParam(name = "accessory", value = "附件对象") @RequestBody List<Accessory> accessoryList) {
        log.info("通用附件管理-批量保存附件信息接口请求参数：{}",accessoryList);
        boolean status = baseService.saveAccess(accessoryList);
        String msg = status ? "保存成功" : "保存失败";
        log.info("通用附件管理-批量保存附件信息接口响应结果：{}",msg);
        return new CommonResult<String>(status, msg);
    }

    @PostMapping("/getBySourceId/{sourceId}")
    @ApiOperation(value = "S-通过资源ID不分页查询附件信息", httpMethod = "POST")
    public CommonResult<List<Accessory>> getBySourceId(@ApiParam(name = "sourceId", value = "资源ID") @PathVariable String sourceId){
        log.info("通用附件管理-通过资源ID查询附件信息接口请求参数：{}",sourceId);
        List<Accessory> result = baseService.getAccessoryBySourceId(sourceId);
        log.info("通用附件管理-通过资源ID查询附件信息响应结果：{}",result);
        return new CommonResult<List<Accessory>>(true,"操作成功",result);
    }

    @PostMapping("/getPageBySourceId")
    @ApiOperation(value = "S-通过资源ID分页查询附件信息",notes = "必须传入SOURCE_ID_", httpMethod = "POST")
    public CommonResult<PageList<Accessory>> getPageBySourceId(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<Accessory> queryFilter){
        log.info("通用附件管理-通过资源ID查询附件信息接口请求参数：{}",queryFilter);
        PageList<Accessory> result = baseService.getAccessoryPageBySourceId(queryFilter);
        log.info("通用附件管理-通过资源ID查询附件信息响应结果：{}",result);
        return new CommonResult<>(true,"操作成功",result);
    }

    @PostMapping("/removeBySourceId/{sourceId}")
    @ApiOperation(value = "S-通过资源ID删除附件信息", httpMethod = "POST")
    public CommonResult<String> removeBySourceId(@ApiParam(name = "source_Id", value = "资源ID") @PathVariable String sourceId) throws Exception {
        log.info("通用附件管理-通过资源ID删除附件信息接口请求参数：{}",sourceId);
        boolean status = baseService.removeBySourceId(sourceId);
        String msg = status ? "删除成功" : "删除失败";
        log.info("通用附件管理-通过资源ID删除附件信息响应结果：{}",msg);
        return new CommonResult<String>(true, msg);
    }

    @PostMapping("/delete")
    @ApiOperation(value = "S-批量删除附件信息", httpMethod = "POST")
    public CommonResult<String> delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) throws Exception {
        log.info("通用附件管理-批量删除附件信息接口请求参数：{}",ids);
        Assert.notNull(ids,"主键集合不能为空");
        boolean state = baseService.removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        log.debug("通用附件管理-批量删除附件信息接口响应结果：{}", msg);
        return new CommonResult<String>(state, msg);
    }

    @PostMapping("/minIoAllDownFile")
    @ApiOperation(value = "S-通用下载接口", httpMethod = "POST", notes = "通用下载接口")
    public void downTest( @ApiParam(name = "ids", value = "ids", required = true)
                          @RequestParam(value = "ids", required = true) String ids,
                          @ApiParam(name = "bizPath", value = "bizPath", required = true)
                          @RequestParam(value = "bizPath", required = true)String bizPath,HttpServletResponse response) throws Exception {
        baseService.minIoDownFile(ids, bizPath,response);
    }

    @PostMapping("/ShardUpload")
    @ApiOperation(value = "S-附件上传接口", httpMethod = "POST", notes = "附件上传接口")
    public CommonResult<String> minioUpload(@ApiParam(name = "chunk",value = "分片文件对象",required = true) @ModelAttribute Chunk chunk, HttpServletResponse response) throws Exception {
        log.info("通用附件管理-附件上传接口请求参数：{}",chunk,response);
        String result = baseService.fileUploadPost(chunk, response);
        boolean status = result.equals("over") || result.equals("ok");
        log.info("通用附件管理-附件上传接口响应结果：{}",result);
        return new CommonResult<String>(status, status?"上传成功":"上传失败",result);
    }

    @PostMapping("/mergeFileToMinIO")
    @ApiOperation(value = "S-合并文件异步上传MinIO", httpMethod = "POST", notes = "合并文件异步上传MinIO")
    public CommonResult<Accessory> mergeFileToMinIO(
            @ApiParam(name = "bizPath",value = "MinIO中的业务文件夹",required = true) @RequestParam String bizPath,
            @ApiParam(name = "fileName",value = "文件名",required = true) @RequestParam String fileName) throws Exception {
        log.info("通用附件管理-合并文件异步上传MinIO接口请求参数：{}",bizPath,fileName);
        Accessory accessory = baseService.minioUpload(bizPath, fileName);
        log.info("通用附件管理-合并文件异步上传MinIO接口响应结果：{}",accessory);
        return new CommonResult<Accessory>(true, "上传成功", accessory);
    }

}

