package com.artfess.cqxy.schedule;


import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.manager.ProgressManageReportManager;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.text.ParseException;

@Component
@EnableScheduling
@Slf4j
public class ProgressRecalSchedule {


    @Resource
    ProgressManageManager progressManageManager;
    @Resource
    ProgressManageReportManager progressManageReportManager;



    /**
     * 工程支付定时重算
     * 工程月报重算
     * 每天01点执行
     * @throws ParseException
     */
    //工单数定时器
    @Scheduled(cron = "0 0 01 * * ?")
    public void scheduleProgressRecal()  {
        progressManageManager.recalManage(null);
        progressManageReportManager.recalManageReport(null);
    }
}
