package com.artfess.cqxy.processManagermant.dao;


import com.artfess.cqxy.processManagermant.model.TechnicalInformation;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 *
 *
 * @author baseli
 * @since 2022年5月13日14:49:44
 */
public interface TechnicalInformationDao extends BaseMapper<TechnicalInformation> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    TechnicalInformation getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<TechnicalInformation> queryAllByPage(IPage<TechnicalInformation> convert2IPage,
                                               @Param(Constants.WRAPPER) Wrapper<TechnicalInformation> convert2Wrapper);

}

