package com.artfess.report.bigScreen.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.report.bigScreen.dao.BladeVisualCategoryDao;
import com.artfess.report.bigScreen.dao.BladeVisualDao;
import com.artfess.report.bigScreen.manager.BladeVisualCategoryManager;
import com.artfess.report.bigScreen.model.BladeVisual;
import com.artfess.report.bigScreen.model.BladeVisualCategory;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 可视化分类表 服务实现类
 *
 * @author 向贞好
 * @company 阿特菲斯
 * @since 2021-07-12
 */
@Service
public class BladeVisualCategoryManagerImpl extends BaseManagerImpl<BladeVisualCategoryDao, BladeVisualCategory> implements BladeVisualCategoryManager {

    @Autowired
    BladeVisualCategoryDao bladeVisualCategoryDao;
    @Autowired
    BladeVisualDao bladeVisualDao;

    @Override
    public PageList<BladeVisualCategory> queryBladeVisualCategory(QueryFilter<BladeVisualCategory> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BladeVisualCategory> result = baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<BladeVisualCategory>(result);
    }

    @Override
    public void updateBatchBladeVisualCategory(String id) {
        UpdateWrapper<BladeVisualCategory> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(StringUtils.isNotBlank(id), "id_", id);
        updateWrapper.set("is_dele_", "1");
        bladeVisualCategoryDao.update(null, updateWrapper);
    }

    @Override
    public void checkByCategoryValue(BladeVisualCategory bladeVisualCategory) {
        QueryWrapper<BladeVisualCategory> queryWrapper = new QueryWrapper<>();
        if(StringUtils.isNotBlank(bladeVisualCategory.getId()))
            queryWrapper.notIn("id_",bladeVisualCategory.getId());
        queryWrapper.eq("category_key_", bladeVisualCategory.getCategoryKey()).or().eq("category_value_", bladeVisualCategory.getCategoryValue());
        List<BladeVisualCategory> categoryList = bladeVisualCategoryDao.selectList(queryWrapper);
        if (categoryList.size() > 0) {
            throw new RuntimeException("该分类名称或者值已经存在");
        }
    }

    @Override
    public List<BladeVisual> getVisual(String categoryValue) {
        QueryWrapper<BladeVisual> wrapper = new QueryWrapper<>();
        wrapper.eq(StringUtils.isNotBlank(categoryValue), "category_", categoryValue);
        List<BladeVisual> bladeVisual = bladeVisualDao.selectList(wrapper);
        return bladeVisual;
    }


}
