package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.MatrixColDefManager;
import com.artfess.uc.model.MatrixColDef;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 
 * <pre> 
 * 描述：矩阵列定义 控制器类
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-06-05 14:02:42
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/uc/matrixColDef/v1")
@Api(tags="matrixColDefController")
@ApiGroup(group = {ApiGroupConsts.GROUP_UC})
public class MatrixColDefController extends BaseController<MatrixColDefManager,MatrixColDef>{
	@Resource
	MatrixColDefManager matrixColDefManager;
	
	/**
	 * 矩阵列定义列表(分页条件查询)数据
	 * @param request
	 * @return
	 * @throws Exception 
	 * PageJson
	 * @exception 
	 */
	@PostMapping("/listJson")
	@ApiOperation(value="矩阵列定义数据列表", httpMethod = "POST", notes = "获取矩阵列定义列表")
	public PageList<MatrixColDef> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter<MatrixColDef> queryFilter) throws Exception{
		return matrixColDefManager.query(queryFilter);
	}
	
	/**
	 * 矩阵列定义明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getJson")
	@ApiOperation(value="矩阵列定义数据详情",httpMethod = "GET",notes = "矩阵列定义数据详情")
	public MatrixColDef get(@ApiParam(name="id",value="业务对象主键", required = true)@RequestParam String id) throws Exception{
		return matrixColDefManager.get(id);
	}
	
    /**
	 * 新增矩阵列定义
	 * @param matrixColDef
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新矩阵列定义数据", httpMethod = "POST", notes = "新增,更新矩阵列定义数据")
	public CommonResult<String> save(@ApiParam(name="matrixColDef",value="矩阵列定义业务对象", required = true)@RequestBody MatrixColDef matrixColDef) throws Exception{
		String msg = "添加矩阵列定义成功";
		if(StringUtil.isEmpty(matrixColDef.getId())){
			matrixColDefManager.create(matrixColDef);
		}else{
			matrixColDefManager.update(matrixColDef);
			 msg = "更新矩阵列定义成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除矩阵列定义记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除矩阵列定义记录", httpMethod = "DELETE", notes = "批量删除矩阵列定义记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		matrixColDefManager.removeByIds(ids);
		return new CommonResult<String>(true, "批量删除成功");
	}
}
