package com.artfess.sysConfig.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.sysConfig.model.ExcelTemp;
import com.artfess.sysConfig.vo.ExcelTempVo;
import com.artfess.sysConfig.vo.TableFieldVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 导入导出模板
 *
 * @author wh
 * @company rzx
 * @since 2021-08-04
 */
public interface ExcelTempManager extends BaseManager<ExcelTemp>{

    ExcelTempVo getExcelTempById(String id);

    ExcelTempVo getExcelTempByCode(String code,Integer type);

    ExcelTemp getExcelTempByTempFiles(String tempFile);

    ExcelTemp getExcelTempByBizCode(String bizCode);

    //保存模板和字段配置
    void save(ExcelTempVo vo);

    //批量删除
    void remove(String ids);

    //查询数据库的表和字段
    List<TableFieldVo> getDataBaseField(String databaseId,String tableSchema, String tableName);
}
