package com.artfess.sysConfig.controller;

import com.artfess.activemq.model.JmsSysTypeChangeMessage;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.sysConfig.model.ExcelTemp;
import com.artfess.sysConfig.model.ExcelTempFields;
import com.artfess.sysConfig.persistence.manager.ExcelTempFieldsManager;
import com.artfess.sysConfig.persistence.manager.ExcelTempManager;
import com.artfess.sysConfig.vo.ExcelTempVo;
import com.artfess.sysConfig.vo.TableFieldVo;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *
 * <pre>
 * 描述：导入导出模板管理
 * 作者:wh
 * 日期:2021-08-04
 * </pre>
 */
@RestController
@RequestMapping("/config/excel/v1")
@Api(tags="导入导出模板管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class ExcelTempController extends BaseController<ExcelTempManager, ExcelTemp>{
	@Resource
	ExcelTempManager excelTempManager;

	@Resource
	ExcelTempFieldsManager excelTempFieldsManager;

	@RequestMapping(value="listJson", method=RequestMethod.POST, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "导入导出模板(分页条件查询)数据", httpMethod = "POST", notes = "导入导出模板(分页条件查询)数据")
	public PageList<ExcelTemp> listJson(@ApiParam(name="queryFilter",value="通用查询对象")@RequestBody QueryFilter queryFilter) throws Exception{
		return excelTempManager.query(queryFilter);
	}

	@RequestMapping(value="getJson", method=RequestMethod.GET, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "模板对象详情", httpMethod = "GET", notes = "模板对象详情")
	public  ExcelTempVo getJson(@ApiParam(name="id",value="主键")@RequestParam String id) throws Exception{
		return excelTempManager.getExcelTempById(id);
	}

	@RequestMapping(value="getJsonByCode", method=RequestMethod.GET, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "根据编码查询模板对象详情", httpMethod = "GET", notes = "根据编码查询模板对象详情")
	public  ExcelTempVo getJsonByCode(@ApiParam(name="id",value="主键")@RequestParam String code,@ApiParam(name="type",value="模板类型")Integer type) throws Exception{
		return excelTempManager.getExcelTempByCode(code,type);
	}

	@RequestMapping(value="save", method=RequestMethod.POST, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "保存信息", httpMethod = "POST", notes = "保存信息")
	public CommonResult save(@ApiParam(name="catalog",value="模板对象")@RequestBody ExcelTempVo vo) throws Exception{
		try {
			excelTempManager.save(vo);
			return new CommonResult("操作成功");
		} catch (Exception e) {
			return new CommonResult(false,"操作失败");
		}
	}

	@RequestMapping(value="remove", method=RequestMethod.DELETE, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "删除模板", httpMethod = "DELETE", notes = "删除模板")
	public CommonResult remove(@ApiParam(name="id",value="主键")@RequestParam	String ids) throws Exception{
		try {
			excelTempManager.removeByIds(ids);
			return new CommonResult("删除成功");
		} catch (Exception e) {
			return new CommonResult(false,"删除失败");
		}
	}


	@RequestMapping(value="getDataBaseField", method=RequestMethod.POST, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "自定义导入模板选择数据表和字段", httpMethod = "POST", notes = "自定义导入模板选择数据表和字段")
	public List<TableFieldVo> getDataBaseField(@ApiParam(name="dataBaseId",value="数据源ID")@RequestParam	String dataBaseId,@ApiParam(name="tableSchema",value="数据库")@RequestParam	String tableSchema, @ApiParam(name="tableName",value="数据表")@RequestParam	String tableName) throws Exception{
		return excelTempManager.getDataBaseField(dataBaseId,tableSchema,tableName);

	}


	@RequestMapping(value="removeField", method=RequestMethod.DELETE, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "删除模板字段", httpMethod = "DELETE", notes = "删除模板字段")
	public CommonResult removeField(@ApiParam(name="id",value="主键")@RequestParam	String id) throws Exception{
		try {
			excelTempFieldsManager.removeById(id);
			return new CommonResult("删除成功");
		} catch (Exception e) {
			return new CommonResult(false,"删除失败");
		}
	}

	//
	@RequestMapping(value="checkTemp", method=RequestMethod.POST, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "验证是否有模版", httpMethod = "POST", notes = "验证是否有模版")
	public ExcelTempVo checkTemp(@ApiParam(name="bizCode",value="编码")@RequestParam String bizCode,@ApiParam(name="type",value="导入导出类型")@RequestParam Integer type) throws Exception {
		ExcelTempVo vo = excelTempManager.getExcelTempByCode(bizCode, type);
		return vo;
	}

	@PostMapping(value = "/upload")
	@ApiOperation("通用上传导入文件测试")
	public CommonResult msgUpload(@RequestBody MultipartFile file) {
		return new CommonResult("成功");
	}
}
