/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectApproval.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectApproval.dao.DecisionBasisDao;
import com.artfess.cqxy.projectApproval.manager.DecisionAnnualPlanManager;
import com.artfess.cqxy.projectApproval.manager.DecisionBasisManager;
import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;
import com.artfess.cqxy.projectApproval.model.DecisionBasis;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DecisionBasisManagerImpl
extends BaseManagerImpl<DecisionBasisDao, DecisionBasis>
implements DecisionBasisManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    ProjectManagementManager pmm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private DecisionAnnualPlanManager decisionAnnualPlanManager;

    public boolean saveOrUpdate(DecisionBasis entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.one.getCode());
            ele.setGroup("DecisionBasis");
            ele.setNode(ProjectStatusEnum.one.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        String decisionAnnualPlanId = entity.getDecisionAnnualPlanId();
        if (null != projectManagement && StringUtils.isNotBlank((CharSequence)decisionAnnualPlanId)) {
            DecisionAnnualPlan decisionAnnualPlan = this.decisionAnnualPlanManager.getById(decisionAnnualPlanId);
            if (projectManagement.getCommencementTime() == null && decisionAnnualPlan != null) {
                projectManagement.setCommencementTime(decisionAnnualPlan.getCommencementTime());
            }
            if (null == projectManagement.getCompletionTime() && decisionAnnualPlan != null) {
                projectManagement.setCompletionTime(decisionAnnualPlan.getCompletionTime());
            }
            this.pmm.updateById((Object)projectManagement);
        }
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, DecisionBasis entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.two.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.two.getName());
        globalRetrieval.setBizTableName(FunctionEnum.two.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.two.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.two.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.two.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.two.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.two.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getDecisionBasisPersion() + "_" + entity.getDecisionBasisDescribe() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public DecisionBasis getById(String id) {
        DecisionBasis result = ((DecisionBasisDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<DecisionBasis> queryAllByPage(QueryFilter<DecisionBasis> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bdb", "pm");
        IPage<DecisionBasis> result = ((DecisionBasisDao)this.baseMapper).queryAllByPage((IPage<DecisionBasis>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<DecisionBasis>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (DecisionBasis ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        List decisionType = this.sdm.queryDictListItemsByCode("xmlx-jcyj-jcwjlx");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, DecisionBasis.class, (ImportParams)new ImportParams());
            for (DecisionBasis ele : data) {
                ele.setProjectId(projectId);
                ele.setDecisionBasisType(BizUtils.getDicCodeByValue(decisionType, ele.getDecisionBasisType()));
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<DecisionBasis> queryFilter, HttpServletResponse response) throws IOException {
        List decisionType = this.sdm.queryDictListItemsByCode("xmlx-jcyj-jcwjlx");
        String fileName = "\u51b3\u7b56\u4f9d\u636e-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bdb", "pm");
        List data = ((DecisionBasisDao)this.baseMapper).queryAllByPage((IPage<DecisionBasis>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<DecisionBasis>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (DecisionBasis ele : data) {
            ele.setDecisionBasisType(BizUtils.getDicValueByCode((List<DictModel>)decisionType, ele.getDecisionBasisType()));
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, DecisionBasis.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

