/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.ledger.manager.ContractLedgerManager;
import com.artfess.cqxy.ledger.vo.ContractKeeperVo;
import com.artfess.cqxy.ledger.vo.ContractLedgerVo;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.projectManagement.dao.ProjectManagementDao;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.google.api.client.util.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractLedgerManagerImpl
implements ContractLedgerManager {
    @Autowired
    private ProjectManagementManager projectManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    ContractManager contractManager;
    @Autowired
    private ProjectPersonnelManager projectPersonnelManager;
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private ProjectManagementDao projectManagementDao;
    @Autowired
    private ProgressManageManager progressManageManager;

    public static String extractNumbers(String input) {
        return input.replaceAll("[^0-9]", "");
    }

    @Override
    public Map<String, Object> queryByPage(QueryFilter<Contract> queryFilter) {
        PageList<Contract> contract;
        List<String> projectList;
        List bidType = this.sdm.queryDictListItemsByCode("zbfs");
        queryFilter.withSorter(new FieldSort("pm.PROJECT_TYPE_", Direction.ASC));
        queryFilter.withSorter(new FieldSort("bc.PROJECT_ID_", Direction.ASC));
        if (BizUtils.isProjectIdFields(queryFilter.getQuerys()).booleanValue() && null != (projectList = BizUtils.handProjectAuthByUser(this.ucFeignService, this.projectPersonnelManager, this.projectManagementDao)) && projectList.size() > 0) {
            queryFilter.addFilter("bc.PROJECT_ID_", projectList, QueryOP.IN);
        }
        List<Object> contractList = null == (contract = this.contractManager.queryContractByPage(queryFilter)).getRows() ? new ArrayList() : contract.getRows();
        ArrayList<ContractLedgerVo> data = new ArrayList<ContractLedgerVo>();
        contractList = contractList.stream().sorted(Comparator.comparing(Contract::getContractNumlong, Comparator.nullsLast(Long::compareTo)).reversed()).collect(Collectors.toList());
        for (Contract contract2 : contractList) {
            ContractLedgerVo temp = ContractLedgerVo.contractToVo(contract2, bidType);
            ProjectManagement project = (ProjectManagement)((Object)this.projectManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)contract2.getProjectId())).eq((Object)"IS_DELE_", (Object)"0")));
            temp.setAgent(project.getProjectManager());
            temp.setProjectName(project.getProjectName());
            temp.setProjectCode(project.getProjectCode());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id_", (Object)contract2.getId());
            queryWrapper.select(new String[]{" IFNULL( max(AMOUNT_APPROPRIATED_),0) as maxAmount"});
            Map map = this.progressManageManager.getMap((Wrapper)queryWrapper);
            DecimalFormat df1 = new DecimalFormat("#.##");
            BigDecimal amountAppropriated = (BigDecimal)map.get("maxAmount");
            if (df1.format(amountAppropriated).equals("0")) {
                temp.setAmountAppropriated("-");
            } else {
                temp.setAmountAppropriated(df1.format(amountAppropriated));
            }
            if (StringUtils.isEmpty((CharSequence)contract2.getContractReceiver())) {
                contract2.setContractReceiver(project.getProjectManager());
            }
            if (temp.getContractAmount() == null || temp.getContractAmount().trim().isEmpty()) {
                temp.setRemainingAmount("-");
                temp.setRatioAmount("0.00%");
            } else {
                BigDecimal bigDecimal;
                if (StringUtils.isNotBlank((CharSequence)temp.getContractAmount())) {
                    bigDecimal = new BigDecimal(temp.getContractAmount());
                    if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                        temp.setRemainingAmount("0.00");
                    } else {
                        temp.setRemainingAmount(df1.format(bigDecimal.subtract(amountAppropriated)));
                    }
                } else {
                    temp.setRemainingAmount("0.00");
                }
                if (StringUtils.isNotBlank((CharSequence)temp.getContractAmount())) {
                    bigDecimal = new BigDecimal(temp.getContractAmount());
                    if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                        temp.setRatioAmount("0.00%");
                    } else {
                        DecimalFormat df = new DecimalFormat("0.00%");
                        String ratio = df.format(amountAppropriated.divide(bigDecimal, 4, 4));
                        temp.setRatioAmount(ratio);
                    }
                } else {
                    temp.setRatioAmount("0.00%");
                }
            }
            data.add(temp);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("data", data);
        result.put("total", contract.getTotal());
        result.put("page", contract.getPage());
        result.put("pageSize", contract.getPageSize());
        return result;
    }

    @Override
    public void exportDataToExcel(QueryFilter<Contract> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "";
        for (QueryField qf : queryFilter.getQuerys()) {
            if (!StringUtil.equals((String)"bc.CONTRACT_NUMBER_", (String)qf.getProperty().trim())) continue;
            fileName = fileName + qf.getValue() + "\u5e74";
        }
        queryFilter.setSorter((List)Lists.newArrayList());
        queryFilter.getPageBean().setPageSize(-1);
        fileName = fileName + "\u5408\u540c\u7ba1\u7406\u53f0\u8d26";
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_", Direction.ASC));
        Map<String, List<ContractLedgerVo>> data = this.classifyData((List)this.queryByPage(queryFilter).get("data"));
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet numberExplanation = workbook.createSheet("\u5408\u540c\u7f16\u53f7\u8bf4\u660e");
        String[] numberData = new String[]{"01 G-\u5de5\u7a0b\u7c7b%\u623f\u5efa\u3001\u5e02\u653f\u9053\u8def\u3001\u7ef4\u4fee\u65bd\u5de5\u5408\u540c\u53ca\u8865\u5145\u534f\u8bae%\uff0820**\uff09\u5efa\u8bbe\u5de5\u7a0b*\u53f7", "02 J-\u6280\u672f\u54a8\u8be2\u7c7b%\u62db\u6807\u4ee3\u7406\u3001\u9020\u4ef7\u54a8\u8be2\u3001\u76d1\u7406\u3001\u65bd\u5de5\u56fe\u8bbe\u8ba1\u5ba1\u67e5\u3001\u8bbe\u8ba1\u3001\u52d8\u5bdf\u5408\u540c\u7b49%\uff0820**\uff09\u5efa\u8bbe\u6280\u672f*\u53f7", "03 F-\u670d\u52a1\u7c7b%\u7ba1\u7406\u670d\u52a1\u3001\u9053\u8def\u8054\u5efa\u3001\u76d1\u6d4b\u94bb\u4e95\u3001\u7ba1\u7f51\u76d1\u6d4b\u5408\u540c%\uff0820**\uff09\u5efa\u8bbe\u670d\u52a1*\u53f7", "04 C-\u91c7\u8d2d\u7c7b%%\uff0820**\uff09\u5efa\u8bbe\u91c7\u8d2d*\u53f7", "05 P-\u914d\u5957\u7c7b%\u5927\u3001\u5c0f\u914d\u5957\u5408\u540c%\uff0820**\uff09\u5efa\u8bbe\u914d\u5957*\u53f7", "06 O-\u5176\u4ed6% % "};
        for (int i = 0; i < numberData.length; ++i) {
            HSSFRow numberTitie = numberExplanation.createRow(i);
            String[] rowData = numberData[i].split("[%]");
            for (int t = 0; t < rowData.length; ++t) {
                BizUtils.handelCell(workbook, "\u5408\u540c\u7f16\u53f7\u8bf4\u660e", numberTitie.createCell(t), rowData[t], new boolean[0]);
            }
        }
        HSSFSheet NoSheet = workbook.getSheet("\u5408\u540c\u7f16\u53f7\u8bf4\u660e");
        NoSheet.setColumnWidth(0, 5000);
        NoSheet.setColumnWidth(1, 8000);
        NoSheet.setColumnWidth(2, 7000);
        String GSheetName = "G-\u5de5\u7a0b\u7c7b\u5408\u540c";
        HSSFSheet GSheet = this.initSheet(workbook, GSheetName, "\u897f\u6c38\u516c\u53f8\u5de5\u7a0b\u9879\u76ee" + GSheetName.split("-")[1] + "\u6267\u884c\u53f0\u8d26");
        this.fillDataToSheet(workbook, GSheetName, data.get("G"));
        String JSheetName = "J-\u6280\u672f\u7c7b\u5408\u540c";
        HSSFSheet JSheet = this.initSheet(workbook, JSheetName, "\u897f\u6c38\u516c\u53f8\u5de5\u7a0b\u9879\u76ee" + JSheetName.split("-")[1] + "\u6267\u884c\u53f0\u8d26");
        this.fillDataToSheet(workbook, JSheetName, data.get("J"));
        String FSheetName = "F-\u670d\u52a1\u7c7b\u5408\u540c";
        HSSFSheet FSheet = this.initSheet(workbook, FSheetName, "\u897f\u6c38\u516c\u53f8\u5de5\u7a0b\u9879\u76ee" + FSheetName.split("-")[1] + "\u6267\u884c\u53f0\u8d26");
        this.fillDataToSheet(workbook, FSheetName, data.get("F"));
        String CSheetName = "C-\u91c7\u8d2d\u7c7b\u5408\u540c";
        HSSFSheet CSheet = this.initSheet(workbook, CSheetName, "\u897f\u6c38\u516c\u53f8\u5de5\u7a0b\u9879\u76ee" + CSheetName.split("-")[1] + "\u6267\u884c\u53f0\u8d26");
        this.fillDataToSheet(workbook, CSheetName, data.get("C"));
        String PSheetName = "P-\u914d\u5957\u7c7b\u5408\u540c";
        HSSFSheet PSheet = this.initSheet(workbook, PSheetName, "\u897f\u6c38\u516c\u53f8\u5de5\u7a0b\u9879\u76ee" + PSheetName.split("-")[1] + "\u6267\u884c\u53f0\u8d26");
        this.fillDataToSheet(workbook, PSheetName, data.get("P"));
        String OSheetName = "O-\u5176\u4ed6\u5408\u540c";
        HSSFSheet OSheet = this.initSheet(workbook, OSheetName, "\u897f\u6c38\u516c\u53f8\u5de5\u7a0b\u9879\u76ee" + OSheetName.split("-")[1] + "\u6267\u884c\u53f0\u8d26");
        this.fillDataToSheet(workbook, OSheetName, data.get("O"));
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateContractReceiverById(ContractKeeperVo contractKeeperVo) {
        String contractReceiver = contractKeeperVo.getContractReceiver();
        String id = contractKeeperVo.getId();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"CONTRACT_RECEIVER_", (Object)contractReceiver)).eq((Object)"ID_", (Object)id);
        this.contractManager.update((Wrapper)updateWrapper);
    }

    private Map<String, List<ContractLedgerVo>> classifyData(List<ContractLedgerVo> data) {
        HashMap<String, List<ContractLedgerVo>> result = new HashMap<String, List<ContractLedgerVo>>(5);
        if (null == data) {
            return result;
        }
        ArrayList<ContractLedgerVo> G = new ArrayList<ContractLedgerVo>();
        ArrayList<ContractLedgerVo> J = new ArrayList<ContractLedgerVo>();
        ArrayList<ContractLedgerVo> F = new ArrayList<ContractLedgerVo>();
        ArrayList<ContractLedgerVo> C = new ArrayList<ContractLedgerVo>();
        ArrayList<ContractLedgerVo> P = new ArrayList<ContractLedgerVo>();
        ArrayList<ContractLedgerVo> O = new ArrayList<ContractLedgerVo>();
        for (ContractLedgerVo ele : data) {
            String type = ele.getContractNumber();
            if (StringUtils.isNotBlank((CharSequence)type) && type.contains("\u5efa\u8bbe\u5de5\u7a0b")) {
                G.add(ele);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)type) && type.contains("\u5efa\u8bbe\u6280\u672f")) {
                J.add(ele);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)type) && type.contains("\u5efa\u8bbe\u670d\u52a1")) {
                F.add(ele);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)type) && type.contains("\u5efa\u8bbe\u91c7\u8d2d")) {
                C.add(ele);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)type) && type.contains("\u5efa\u8bbe\u914d\u5957")) {
                P.add(ele);
                continue;
            }
            O.add(ele);
        }
        result.put("G", G);
        result.put("J", J);
        result.put("F", F);
        result.put("C", C);
        result.put("P", P);
        result.put("O", O);
        return result;
    }

    private HSSFSheet initSheet(HSSFWorkbook workbook, String sheetName, String titile) {
        HSSFSheet sheet = workbook.createSheet(sheetName);
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        String[] heards = new String[]{"\u5e8f\u53f7", "\u5408\u540c\u7f16\u53f7", "\u4e8c\u7ea7\u5206\u7c7b", "\u62db\u6807\u65b9\u5f0f", "\u51b3\u7b56\u6587\u4ef6", "\u5408\u540c\u7c7b\u522b", "\u5408\u540c\u6d89\u53ca\u4e8b\u9879", "\u6211\u65b9\u4e3b\u4f53", "\u5176\u4ed6\u76f8\u5bf9\u65b9\u4e3b\u4f53", "\u5408\u540c\u7b7e\u8ba2\u65f6\u95f4", "\u5408\u540c\u7ea6\u5b9a\u5b8c\u6210\u65f6\u95f4", "\u6295\u8d44\u603b\u91d1\u989d\uff08\u4e07\u5143\uff09", "\u5df2\u652f\u4ed8\u91d1\u989d\uff08\u4e07\u5143\uff09", "\u5269\u4f59\u91d1\u989d\uff08\u4e07\u5143\uff09", "\u5df2\u652f\u4ed8\u6bd4\u4f8b", "\u5408\u540c\u5c65\u884c\u5f02\u5e38\u8bb0\u5f55", "\u5408\u540c\u6267\u884c\u8fdb\u5ea6", "\u9879\u76ee\u8d1f\u8d23\u4eba", "\u7559\u5b58\u4efd\u6570", "\u5907\u6ce8", "\u5408\u540c\u5b58\u653e\u5904", "\u5408\u540c\u4fdd\u7ba1\u4eba", "\u5408\u540c\u7ecf\u529e\u4eba"};
        HSSFRow tiele = sheet.createRow(0);
        BizUtils.handelCell(workbook, cellStyle, font, sheetName, tiele.createCell(0), titile, true);
        HSSFRow titleRow1 = sheet.createRow(1);
        for (int i = 0; i < heards.length; ++i) {
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, titleRow1.createCell(i), heards[i], new boolean[0]);
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 22));
        return sheet;
    }

    private void fillDataToSheet(HSSFWorkbook workbook, String sheetName, List<ContractLedgerVo> data) {
        HSSFSheet sheet = workbook.getSheet(sheetName);
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        for (int i = 0; i < data.size(); ++i) {
            HSSFRow listRow = sheet.createRow(i + 2);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(0), String.valueOf(i + 1), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(1), StringUtils.isEmpty((CharSequence)data.get(i).getContractNumber()) ? "\u65e0" : data.get(i).getContractNumber(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(2), StringUtils.isEmpty((CharSequence)data.get(i).getSecondLevelType()) ? "\u65e0" : data.get(i).getSecondLevelType(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(3), StringUtils.isEmpty((CharSequence)data.get(i).getBiddingChargeType()) ? "\u65e0" : data.get(i).getBiddingChargeType(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(4), StringUtils.isEmpty((CharSequence)data.get(i).getDecisionDocuments()) ? "\u65e0" : data.get(i).getDecisionDocuments(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(5), StringUtils.isEmpty((CharSequence)data.get(i).getType()) ? "\u65e0" : data.get(i).getType(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(6), StringUtils.isEmpty((CharSequence)data.get(i).getName()) ? "\u65e0" : data.get(i).getName(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(7), StringUtils.isEmpty((CharSequence)data.get(i).getOurPart()) ? "\u65e0" : data.get(i).getOurPart(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(8), StringUtils.isEmpty((CharSequence)data.get(i).getOtherPart()) ? "\u65e0" : data.get(i).getOtherPart(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(9), StringUtils.isEmpty((CharSequence)data.get(i).getContractDate()) ? "\u65e0" : data.get(i).getContractDate(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(10), StringUtils.isEmpty((CharSequence)data.get(i).getEndDate()) ? "\u65e0" : data.get(i).getEndDate(), new boolean[0]);
            if (StringUtils.isEmpty((CharSequence)data.get(i).getContractAmount()) || "-".equalsIgnoreCase(data.get(i).getContractAmount())) {
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(11), "-", new boolean[0]);
            } else {
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(11), Double.valueOf(data.get(i).getContractAmount()), new boolean[0]);
            }
            if (StringUtils.isEmpty((CharSequence)data.get(i).getAmountAppropriated()) || "-".equalsIgnoreCase(data.get(i).getAmountAppropriated())) {
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(12), "-", new boolean[0]);
            } else {
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(12), Double.valueOf(data.get(i).getAmountAppropriated()), new boolean[0]);
            }
            if (StringUtils.isEmpty((CharSequence)data.get(i).getRemainingAmount()) || "-".equalsIgnoreCase(data.get(i).getRemainingAmount())) {
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(13), "-", new boolean[0]);
            } else {
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(13), Double.valueOf(data.get(i).getRemainingAmount()), new boolean[0]);
            }
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(14), StringUtils.isEmpty((CharSequence)data.get(i).getRatioAmount()) ? "\u65e0" : data.get(i).getRatioAmount(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(15), StringUtils.isEmpty((CharSequence)data.get(i).getContractExceptionLog()) ? "\u65e0" : data.get(i).getContractExceptionLog(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(16), StringUtils.isEmpty((CharSequence)data.get(i).getContractSchedule()) ? "\u65e0" : data.get(i).getContractSchedule(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(17), StringUtils.isEmpty((CharSequence)data.get(i).getAgent()) ? "\u65e0" : data.get(i).getAgent(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(18), StringUtils.isEmpty((CharSequence)data.get(i).getContractCopsNum().toString()) ? "\u65e0" : data.get(i).getContractCopsNum().toString(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(19), StringUtils.isEmpty((CharSequence)data.get(i).getEstablishmentRemarks()) ? "\u65e0" : data.get(i).getEstablishmentRemarks(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(20), StringUtils.isEmpty((CharSequence)data.get(i).getContractStorage()) ? "\u65e0" : data.get(i).getContractStorage(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(21), StringUtils.isEmpty((CharSequence)data.get(i).getContractKeeper()) ? "\u65e0" : data.get(i).getContractKeeper(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, sheetName, listRow.createCell(22), StringUtils.isEmpty((CharSequence)data.get(i).getContractReceiver()) ? "\u65e0" : data.get(i).getContractReceiver(), new boolean[0]);
        }
        sheet.setColumnWidth(0, 2000);
        sheet.setColumnWidth(1, 4000);
        sheet.setColumnWidth(2, 2000);
        sheet.setColumnWidth(3, 4000);
        sheet.setColumnWidth(4, 3000);
        sheet.setColumnWidth(5, 4000);
        sheet.setColumnWidth(6, 6000);
        sheet.setColumnWidth(7, 6000);
        sheet.setColumnWidth(8, 4000);
        sheet.setColumnWidth(9, 4000);
        sheet.setColumnWidth(10, 4000);
        sheet.setColumnWidth(11, 4000);
        sheet.setColumnWidth(12, 4000);
        sheet.setColumnWidth(13, 4000);
        sheet.setColumnWidth(14, 4000);
        sheet.setColumnWidth(15, 4000);
        sheet.setColumnWidth(16, 4000);
        sheet.setColumnWidth(17, 4000);
        sheet.setColumnWidth(18, 3000);
        sheet.setColumnWidth(19, 3000);
        sheet.setColumnWidth(20, 3000);
        sheet.setColumnWidth(21, 3000);
        sheet.setColumnWidth(22, 3000);
    }
}

