/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.bidManagement.manager.BiddingManagementManager;
import com.artfess.cqxy.bidManagement.model.BiddingManagement;
import com.artfess.cqxy.ledger.manager.BiddingLedgerManager;
import com.artfess.cqxy.ledger.vo.BiddingLedgerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53f0\u8d26-\u62db\u6295\u6807\u53f0\u8d26\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/ledger/biddingLedger/v1"})
public class BiddingLedgerController {
    private static final Logger log = LoggerFactory.getLogger(BiddingLedgerController.class);
    @Autowired
    private BiddingLedgerManager manager;
    @Autowired
    private BiddingManagementManager biddingManagementManager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", httpMethod="POST")
    public CommonResult<PageList<BiddingLedgerVo>> page(@ApiParam(name="queryFilter", value="\u62db\u6295\u6807\u67e5\u8be2\u5668") @RequestBody QueryFilter<BiddingManagement> queryFilter) {
        PageList<BiddingLedgerVo> result = this.manager.queryByPage(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e(\u65b0)", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570\uff0c\u4f20\u5165 PROJECT_ID_ \u9879\u76eeID \u4ee5\u5207\u6362\u9879\u76ee\uff0c\u6240\u6709\u53c2\u6570\u90fd\u9700\u8981\u5e26\u4e0a\u8868\u522b\u540d\u2014\u2014\u4e3b\u8868\u4e3abbm\u3001\u526f\u8868\u4e3apm", httpMethod="POST")
    public CommonResult<PageList<BiddingManagement>> selectAll(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BiddingManagement> queryFilter) {
        PageList<BiddingManagement> result = this.biddingManagementManager.queryAllByPage(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="S-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u4f7f\u7528\u9879\u76ee\u7ba1\u7406\u67e5\u8be2\u5668")
    public CommonResult exportDataToExcel(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BiddingManagement> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("\u5bfc\u51fa\u6570\u636e\u5230Excel\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter, (Object)response);
        this.manager.exportDataToExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }
}

