package com.artfess.cqxy.wps.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author 黎沐华
 * @date 2022/5/6 16:13
 */
@Data
@ApiModel("水印配置")
public class Watermark {

    @ApiModelProperty("水印类型， 0为无水印； 1为文字水印")
    private final Integer type = 1;

    @ApiModelProperty("水印文本值，当type为1时，此字段必填")
    private final String value = "西永微电子产业园区";

    @ApiModelProperty("水印颜色，非必填，有默认值")
    private final String fillstyle = "rgba( 192, 192, 192, 0.6 )";

    @ApiModelProperty("水印字体，非必填，有默认值")
    private final String font = "bold 20px Serif";

    @ApiModelProperty("水印的旋转度，非必填，有默认值")
    private final BigDecimal rotate = new BigDecimal(-0.7853982);

    @ApiModelProperty("水印水平间距，非必填，有默认值")
    private final Integer horizontal = 50;

    @ApiModelProperty("水印水平间距，非必填，有默认值")
    private final Integer vertical = 100;

}
