package com.artfess.cqxy.projectManagement.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.ProjectPersonnel;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目人员中间表(BizProjectPersonnel)表控制层
 *
 * @author 黎沐华
 * @since 2022-02-12 14:41:17
 */
@Slf4j
@RestController
@Api(tags = "项目管理-项目人员接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/projectManagement/projectPersonnel/v1")
public class ProjectPersonnelController extends BaseController<ProjectPersonnelManager, ProjectPersonnel> {

    /**
     * 保存数据
     * @param perObject 实体对象
     * @return 新增结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-保存数据",notes = "约定可以将多个人员ID放到一个personnelId中，以英文逗号隔开，后端做批量新增",httpMethod = "POST")
    public CommonResult<String> save(@ApiParam(name = "dirObject", value = "目录管理信息表对象") @RequestBody ProjectPersonnel perObject) {
        log.debug("项目人员-保存数据接口请求参数：{}", perObject);
        ProjectPersonnelManager s = baseService;
        boolean result = baseService.batchSaveData(perObject);
        log.debug("项目人员-保存数据接口响应结果：{}", result);
        return new CommonResult<>(result, result?"操作成功":"操作失败");
    }

    /**
     * 删除数据
     * @param ids 主键集合
     * @return 删除结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "S-删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        log.debug("项目人员-删除数据接口请求参数：{}", ids);
        Assert.notNull(ids,"主键集合不能为空");
        boolean state = baseService.removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        log.debug("项目人员-删除数据接口响应结果：{}", msg);
        return new CommonResult<>(state, msg);
    }

    /**
     * 通过主键查询单条数据
     * @param id 主键
     * @return 单条数据
     */
    @PostMapping("/detail/{id}")
    @ApiOperation(value = "S-根据ID查询详情",httpMethod = "POST")
    public CommonResult<ProjectPersonnelVo> selectOne(@ApiParam(name = "id",value = "主键ID") @PathVariable String id) {
        log.debug("项目人员-根据ID查询详情 接口请求参数：{}", id);
        Assert.notNull(id,"主键不能为空");
        ProjectPersonnelVo result = baseService.getVoById(id);
        boolean state = !BeanUtils.isEmpty(result);
        log.debug("项目人员-根据ID查询详情 接口响应结果：{}", result);
        return new CommonResult(state, state?"操作成功":"该ID没有对应数据", result);
    }

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 所有数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据",notes = "参数说明：在通用查询器中的query对象组传入查询参数，必须传入 projectId 项目ID，所有参数都需要带上表别名——主表为pp、副表为uc",httpMethod = "POST")
    public CommonResult<PageList<ProjectPersonnelVo>> selectAll(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<ProjectPersonnel> queryFilter) {
        // 实际应用场景只会有一个部门，故目前仅查询了所有用户信息，可能会有变动
        log.debug("项目人员-分页查询所有数据接口请求参数：{}", queryFilter);
        PageList<ProjectPersonnelVo> result = baseService.queryAllByPage(queryFilter);
        log.debug("项目人员-分页查询所有数据接口响应结果：{}", result);
        return new CommonResult<>(true,"操作成功",result);
    }

    /**
     * 获取所有用户信息以供添加
     * @return 用户Vo
     */
    @PostMapping("/getAllUsers")
    @ApiOperation(value = "S-获取用户信息供添加时选择",httpMethod = "POST")
    public CommonResult<List<ProjectPersonnelVo>> getAllUsers(String projectId) {
        log.debug("项目人员-获取用户信息接口请求开始......");
        List<ProjectPersonnelVo> result = baseService.getAllUsers(projectId);
        log.debug("项目人员-获取用户信息接口响应结果：{}", result);
        return new CommonResult<List<ProjectPersonnelVo>>(true,"操作成功", result);
    }

}

