package com.artfess.cqxy.projectApproval.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.projectApproval.model.DecisionBasis;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 决策依据表(BizDecisionBasis)表服务接口
 * @author 黎沐华
 * @since 2022-02-14 13:57:39
 */
public interface DecisionBasisManager extends BaseManager<DecisionBasis> {

    void importExcelData(MultipartFile file, String projectId);

    boolean deleteByIds(List<String> ids);

    void exportDatatoExcel(QueryFilter<DecisionBasis> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    DecisionBasis getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<DecisionBasis> queryAllByPage(QueryFilter<DecisionBasis> queryFilter);


    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);

}

