package com.artfess.cqxy.projectApproval.dao;

import com.artfess.cqxy.projectApproval.model.DecisionBasis;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 决策依据表(BizDecisionBasis)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-14 13:57:39
 */
public interface DecisionBasisDao extends BaseMapper<DecisionBasis> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    DecisionBasis getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<DecisionBasis> queryAllByPage(IPage<DecisionBasis> convert2IPage, @Param(Constants.WRAPPER) Wrapper<DecisionBasis> convert2Wrapper);

}

