package com.artfess.cqxy.processManagermant.vo;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.processManagermant.model.ProgressManageDefinite;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 进度管理(BizProgressManage)VO,用于查看界面汇总数据查询
 *
 * @author baseli
 * @since 2022-03-04 16:49:30
 */
@Data
@ApiModel(value="过程管理-进度管理-工程支付-查看界面支付汇总 ProgressManageTotalVo", description="过程管理-进度管理表-工程支付查看界面支付汇总Vo")
public class ProgressManageTotalVo {



    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

//    @ApiModelProperty(value = "关联合同ID（关联合同信息表）")
//    private String contractId;
//
//    @ApiModelProperty(value = "部室(子公司）")
//    private String dept;
//
//    @ApiModelProperty(value = "账号")
//    private String handlerPerson;

    @ApiModelProperty(value = "审批日期，（默认今天，时间格式：2022-02-22）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate registerDate;

    @ApiModelProperty(value = "用途（使用字典：1：工程款，）")
    private String purpose;

    @ApiModelProperty(value = "总投资额（单位：万元）")
    @BigDecimalFormat
    private BigDecimal totalInvestment;

    @ApiModelProperty(value = "已拨款金额（单位：万元）")
    @BigDecimalFormat
    private BigDecimal amountAppropriated;

    @ApiModelProperty(value = "支付比例")
    private String measurementData;

    @ApiModelProperty(value = "未拨款金额（单位：万元）")
    @BigDecimalFormat
    private BigDecimal outputValue;


    @ApiModelProperty(value = "备注")
    private String remarks;

    //    @ApiModelProperty(value = "本次拨付总额（单位：万元）")
//    @BigDecimalFormat
//    private BigDecimal payeeAmountTotal;

//    @TableField("CONTRACT_AGREEMENT_")
//    @ApiModelProperty(value = "合同协议（单位：份）")
//    private Integer contractAgreement;
//
//    @TableField("SUPERVISOR_CONTRACT_")
//    @ApiModelProperty(value = "监理合同（单位：份）")
//    private Integer supervisorContract;
//
//    @ApiModelProperty(value = "是否有资金计划（0：是，1：否）")
//    private String haveFundPlan;
//
//
//    @ApiModelProperty(value = "结算票据（使用字典：1：发票，2：收据，3：其他）")
//    private String settlementBillType;
//
//
//    @ApiModelProperty(value = "票据号码")
//    private String settlementBillNum;
//
//    @ApiModelProperty(value = "大写金额（前端使用插件自动写入）")
//    private String amountTotalWords;


    @Override
    public String toString() {
        return "ProgressManageTotalVo{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", registerDate=" + registerDate +
                ", purpose='" + purpose + '\'' +
                ", totalInvestment=" + totalInvestment +
                ", amountAppropriated=" + amountAppropriated +
                ", measurementData='" + measurementData + '\'' +
                ", outputValue=" + outputValue +
                ", remarks='" + remarks + '\'' +
                '}';
    }
}

