package com.artfess.cqxy.processManagermant.dao;

import java.util.List;

import com.artfess.cqxy.processManagermant.model.QualityRectification;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.processManagermant.model.QualityRectification;

/**
 * 过程管理 - 质量管理-质量整改(BizQualityRectification)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-03 16:27:05
 */
public interface QualityRectificationDao extends BaseMapper<QualityRectification> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    QualityRectification getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<QualityRectification> queryAllByPage(IPage<QualityRectification> convert2IPage, @Param(Constants.WRAPPER) Wrapper<QualityRectification> convert2Wrapper);

}

