package com.artfess.cqxy.documentLibrary.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.documentLibrary.model.FileLibrary;
import com.artfess.cqxy.documentLibrary.manager.FileLibraryManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;

/**
 * 文件库表(FileLibrary)表控制层
 *
 * @author 黎沐华
 * @since 2022-04-02 09:22:25
 */
@Slf4j
@RestController
@Api(tags = "文件库接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/fileLibrary/v1")
public class FileLibraryController extends BaseController<FileLibraryManager, FileLibrary> {

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据",notes = "参数说明：在通用查询器中的query对象组传入查询参数，所有参数都需要带上表别名——主表为bfl 文件库、副表为bflt 文件库类型",httpMethod = "POST")
    public CommonResult<PageList<FileLibrary>> selectAll(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<FileLibrary> queryFilter) {
        log.debug("文件库-分页查询所有数据接口请求参数：{}", queryFilter);
        PageList<FileLibrary> result = baseService.queryAllByPage(queryFilter);
        log.debug("文件库-分页查询所有数据接口响应结果：{}", result);
        return new CommonResult<>(true,"操作成功",result);
    }

    /**
     * 保存或修改数据
     * @param fileLibrary 实体对象
     * @return 新增或更新结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-保存或修改数据",httpMethod = "POST")
    public CommonResult insert(@RequestBody FileLibrary fileLibrary) {
        log.debug("文件库-保存或修改数据接口请求参数：{}", fileLibrary);
        boolean add = StringUtils.isEmpty(fileLibrary.getId());
        boolean save = baseService.saveOrUpdate(fileLibrary);
        String msg = (add ? "添加" : "修改")+(save ? "成功" : "失败");
        log.debug("文件库-保存或修改数据接口响应结果：{}", msg);
        return new CommonResult(save, msg);
    }

    /**
     * 删除数据
     * @param ids 主键集合
     * @return 删除结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "S-删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        log.debug("文件库-删除数据接口请求参数：{}", ids);
        Assert.notNull(ids,"主键集合不能为空");
        boolean state = baseService.deleteByIds(ids);
        String msg = state ? "删除成功" : "删除失败";
        log.debug("文件库-删除数据接口响应结果：{}", msg);
        return new CommonResult<String>(state, msg);
    }

    /**
     * 通过主键查询单条数据
     * @param id 主键
     * @return 单条数据
     */
    @PostMapping("/detail/{id}")
    @ApiOperation(value = "S-根据ID查询详情",httpMethod = "POST")
    public CommonResult<FileLibrary> selectOne(@ApiParam(name = "id",value = "主键ID") @PathVariable String id) {
        log.debug("文件库-根据ID查询详情 接口请求参数：{}", id);
        Assert.notNull(id,"主键不能为空");
        FileLibrary result = baseService.get(id);
        boolean state = !BeanUtils.isEmpty(result);
        log.debug("文件库-根据ID查询详情 接口响应结果：{}", result);
        return new CommonResult<FileLibrary>(state, state?"操作成功":"该ID没有对应数据", result);
    }

}

