package com.artfess.cqxy.designEstimate.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 设计概算 - 地勘
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 荣涛
 * @since 2022-10-20
 */
@Data
@TableName("BIZ_GEOLOGICAL_PROSPECTING")
@ApiModel(value="设计概算-地勘-GeologicalProspecting", description="地勘表")
public class GeologicalProspecting extends BizModel<GeologicalProspecting> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @Excel(name = "地勘文号")
    @ApiModelProperty(value = "地勘文号")
    @TableField("DOCUMENT_NUMBER_")
    private String documentNumber;

    @Excel(name = "勘察单位")
    @ApiModelProperty(value = "勘察单位")
    @TableField("GEOLOGICAL_PROSPECTING_UNIT_")
    private String geologicalProspectingUnit;

    @Excel(name = "勘察日期")
    @ApiModelProperty(value = "勘察日期")
    @TableField("PROSPECTING_DATE_")
    private LocalDate prospectingDate;

    @Excel(name = "勘察结果")
    @ApiModelProperty(value = "勘察结果")
    @TableField("CONSTRUCTION_SCALE_")
    private String constructionScale;

    @Excel(name = "备注")
    @ApiModelProperty(value = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    private String establishmentRemarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizGeologicalProspecting{" +
                "id=" + id +
                ", projectId=" + projectId +
                ", documentNumber=" + documentNumber +
                ", geologicalProspectingUnit=" + geologicalProspectingUnit +
                ", prospectingDate=" + prospectingDate +
                ", constructionScale=" + constructionScale +
                ", establishmentRemarks=" + establishmentRemarks;
    }
}
