package com.artfess.cqxy.contract.vo;

import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.contract.model.Item;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author Limuhua
 * @date 2022/2/26 10:45
 */
@ApiModel(value="合同VO对象-ContractVo")
public class ContractVo {

    @ApiModelProperty(value = "项目信息")
    private ProjectManagement project;

    @ApiModelProperty(value = "合同信息")
    private Contract contract;

    @ApiModelProperty(value = "合同明细信息")
    private List<Item> contractItem;

    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    @Override
    public String toString() {
        return "ContractVo{" +
                "project=" + project +
                ", contract=" + contract +
                ", contractItem=" + contractItem +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

    public ContractVo() {
    }

    public ContractVo(Contract contract, List<Item> contractItem) {
        this.contract = contract;
        this.contractItem = contractItem;
    }

    public ContractVo(ProjectManagement project, Contract contract, List<Item> contractItem) {
        this.project = project;
        this.contract = contract;
        this.contractItem = contractItem;
    }

    public ContractVo(ProjectManagement project, Contract contract, List<Item> contractItem, List<Accessory> accessoryInfo) {
        this.project = project;
        this.contract = contract;
        this.contractItem = contractItem;
        this.accessoryInfo = accessoryInfo;
    }

    public List<Accessory> getAccessoryInfo() {
        return accessoryInfo;
    }

    public void setAccessoryInfo(List<Accessory> accessoryInfo) {
        this.accessoryInfo = accessoryInfo;
    }

    public Contract getContract() {
        return contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public List<Item> getContractItem() {
        return contractItem;
    }

    public void setContractItem(List<Item> contractItem) {
        this.contractItem = contractItem;
    }

    public ProjectManagement getProject() {
        return project;
    }

    public void setProject(ProjectManagement project) {
        this.project = project;
    }
}
