package com.artfess.cqxy.contract.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.contract.vo.ContractVo;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 合同管理表(BizContract)表服务接口
 *
 * @author 黎沐华
 * @since 2022-02-26 10:35:04
 */
public interface ContractManager extends BaseManager<Contract> {

    boolean saveContract(ContractVo vo);

    boolean updateContract(ContractVo vo);

    boolean removeContractByIds(List<String> ids);

    PageList<ContractVo> queryAllByPage(QueryFilter<Contract> queryFilter);

    PageList<Contract> queryContractByPage(QueryFilter<Contract> queryFilter);

    ContractVo getVoById(String id);

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel(QueryFilter<Contract> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);

    /**
     * 根据条件查询合同统计情况
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo);

    /**
     * 根据项目ID查询出项目所有施工合同总金额
     * @param projectId 项目ID
     * @return 施工合同总金额（单位：万元，四舍五入不保留小数）
     */
    BigDecimal queryConstructionAmount(String projectId);

    /**
     * 根据项目ID查询出项目所有施工合同总金额
     * @param projectId 项目ID
     * @return 施工合同总金额（单位：万元，四舍五入保留两位小数）
     */
    BigDecimal queryConstructionAmount2(String projectId);

    void downloadBatch(String projectId, List<String> contractIds, HttpServletResponse response);
}

