package com.artfess.cqxy.completionAcceptance.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 竣工验收 - 竣工验收表(CompletionAcceptance)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-07 14:28:02
 */
@Data
@TableName("biz_completion_acceptance")
@ApiModel(value = "竣工验收-CompletionAcceptance", description = "竣工验收表")
public class CompletionAcceptance extends BizModel<CompletionAcceptance> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "竣工验收名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "竣工验收名称")
    private String name;

    @Excel(name = "竣工验收日期", format = "yyyy-MM-dd")
    @TableField("COMPLETION_ACCEPTANCE_DATE_")
    @ApiModelProperty(value = "竣工验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionAcceptanceDate;

    @Excel(name = "工程验收范围")
    @TableField("PROJECT_ACCEPTANCE_SCOPE_")
    @ApiModelProperty(value = "工程验收范围")
    private String projectAcceptanceScope;

    @Excel(name = "专门情况说明")
    @TableField("SPECIALIN_FORMATION_")
    @ApiModelProperty(value = "工程名称（与项目名称相同，选择项目后自动填入）")
    private String specialInformation;

    @Excel(name = "竣工验收意见")
    @TableField("COMPLETION_ACCEPTANCE_OPINIONS_")
    @ApiModelProperty(value = "竣工验收意见")
    private String completionAcceptanceOpinions;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}

