package com.artfess.cqxy.projectManagement.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.projectManagement.model.ProjectPersonnelMenu;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelMenuVo;
import com.artfess.sysConfig.persistence.model.SysMenu;

import java.util.List;
import java.util.Map;

/**
 * 项目人员菜单中间表(BizProjectPersonnelMenu)表服务接口
 *
 * @author baseli
 * @since 2022年5月30日12:59:32
 */
public interface ProjectPersonnelMenuManager {

    /**
     * 根据项目、人员进行菜单授权
     * @param projectPersonnelMenuVo
     */
    void create(ProjectPersonnelMenuVo projectPersonnelMenuVo);

    /**
     * 根据项目、人员查询菜单授权树
     * @param projectId
     * @param userId
     * @param status
     * @return
     */
    List<Map<String, Object>> getAllMenuByProject(String projectId, String userId, String status) throws Exception;

    /**
     * 根据项目ID获取当前用户的菜单
     * @param projectId
     * @param menuAlias
     * @return
     */
    List<SysMenu> getCurrentUserMenuByProject(String projectId, String menuAlias) throws Exception;
}
