package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.cqxy.ledger.manager.MenuCustomizeFieldManager;
import com.artfess.cqxy.ledger.model.MenuCustomizeField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 自定义台账字段查询
 *
 * @author baseli
 * @since 2022年6月5日20:09:57
 */
@Slf4j
@RestController
@Api(tags = "台账-自定义台账-菜单自定义配置字段接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/menuCustomizeField/v1")
public class MenuCustomizeFieldController extends BaseController<MenuCustomizeFieldManager, MenuCustomizeField> {


    /**
     * 删除数据
     * @param ids 主键集合
     * @return 删除结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "S-批量删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        Assert.notNull(ids,"主键集合不能为空");
        baseService.removeByIds(Arrays.asList(ids.split(",")));
        return new CommonResult<String>(true, "数据删除成功");
    }

    /**
     * 保存或修改数据
     * @param menuCustomizeFieldList 实体对象集合
     * @return 新增或更新结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-批量保存或修改数据",httpMethod = "POST")
    public CommonResult save(@RequestBody List<MenuCustomizeField> menuCustomizeFieldList) {
        Assert.notNull(menuCustomizeFieldList,"参数不能为空");
//        baseService.saveBatch(menuCustomizeFieldList);
        for (MenuCustomizeField menuCustomizeField : menuCustomizeFieldList){
            baseService.saveOrUpdate(menuCustomizeField);
        }
        return new CommonResult(true, "数据保存成功！");
    }

    /**
     * 根据模板对象ID查询数据
     * @param tempId 模板对象ID
     * @return 数据
     */
    @GetMapping("/getDataByDepId/{tempId}")
    @ApiOperation(value = "S-根据ID查询数据、预览数据",httpMethod = "GET")
    public CommonResult<List<MenuCustomizeField>> getDataById(@ApiParam(name = "tempId",value = "模板ID") @PathVariable String tempId) {
        Assert.notNull(tempId,"参数不能为空");
        QueryWrapper<MenuCustomizeField> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("TEMP_ID_", tempId);
        queryWrapper.orderByAsc("MENU_ALIAS_");
        return new CommonResult(true, "数据保存成功！", baseService.list(queryWrapper));
    }

}

