package com.artfess.uc.service.impl;

import com.artfess.base.service.LoginUserService;
import com.artfess.base.util.IPUtils;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

@Primary
@Service
public class LoginUserServiceImpl implements LoginUserService {

	protected static Logger logger = LoggerFactory.getLogger(LoginUserServiceImpl.class);

	@Resource
	UserManager userManager;

	@Override
	@Transactional
	public void lockedUser(String account,int lockedStatus) {
		try {
			User user = userManager.getByAccount(account);
			user.setLockedStatus(lockedStatus);
			if(lockedStatus==2) {
				user.setLockedTime(LocalDateTime.now());
			}else{
				user.setLockedTime(null);
			}
			userManager.update(user);
		} catch (Exception e) {
			logger.error("锁定用户账号失败："+e.getMessage());
		}
	}

	@Override
	public void updateLastLoginTime(String account) {
		try {
			User user = userManager.getByAccount(account);
			user.setLastLoginTime(LocalDateTime.now());
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes())
					.getRequest();
			user.setIP(IPUtils.getIpAddr(request));
			userManager.update(user);
		} catch (Exception e) {
			logger.error("修改最后登录时间失败："+e.getMessage());
		}
	}

	@Override
	public void updateUserIp() {
		try {
			userManager.updateUserIP();
		} catch (Exception e) {
			logger.error("修改用户登录机器IP失败："+e.getMessage());
		}
	}


}
