package com.artfess.uc.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import java.time.LocalDateTime;

/**
 * 矩阵列定义
 * 
 * <pre>
 *  
 * 描述：矩阵列定义 实体对象
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-06-05 14:02:42
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@TableName("uc_matrix_col_def")
@ApiModel(value = "MatrixColDef", description = "矩阵列定义")
public class MatrixColDef extends BaseModel<MatrixColDef> {
	//主键id
	public static final String ID_ = "ID_";
	//条件列key前缀
	public static final String CONDK_ = "CONDK_";
	
	//条件列value前缀
	public static final String CONDV_ = "CONDV_";
	
	//角色列前缀
	public static final String ROLE_ = "ROLE_";
	
	/**
	 * 列类型：条件类型
	 */
	public static final Integer COND_COL_TYPE = 1;
	/**
	 * 列类型：角色类型
	 */
	public static final Integer ROLE_COL_TYPE = 2;

	private static final long serialVersionUID = 1L;
	@XmlTransient
	@TableId("ID_")
	@ApiModelProperty(value = "主键")
	protected String id;

	@XmlAttribute(name = "matrixId")
	@TableField("MATRIX_ID_")
	@ApiModelProperty(value = "所属矩阵ID")
	protected String matrixId;

	@XmlAttribute(name = "code")
	@TableField("CODE_")
	@ApiModelProperty(value = "列字段名")
	protected String code;

	@XmlAttribute(name = "name")
	@TableField("NAME_")
	@ApiModelProperty(value = "列中文名")
	protected String name;

	@XmlAttribute(name = "status")
	@TableField("STATUS_")
	@ApiModelProperty(value = "列状态：0未创建列、1已创建列")
	protected Integer status=0;

	@XmlAttribute(name = "colType")
	@TableField("COL_TYPE_")
	@ApiModelProperty(value = "列类型：1条件列、2角色列")
	protected Integer colType;

	@XmlAttribute(name = "selectType")
	@TableField("SELECT_TYPE_")
	@ApiModelProperty(value = "选择类型：1单选、2多选")
	protected Integer selectType;

	@XmlAttribute(name = "colConfig")
	@TableField("COL_CONFIG_")
	@ApiModelProperty(value = "列配置信息")
	protected String colConfig;

	@XmlAttribute(name = "isDele")
	@TableField("IS_DELE_")
	@ApiModelProperty(value = "是否删除：0未删、1已删")
	protected Integer isDele=0;

	@XmlAttribute(name = "createBy")
	@TableField("CREATE_BY_")
	@ApiModelProperty(value = "创建人")
	protected String createBy;

	@XmlAttribute(name = "createTime")
	@TableField("CREATE_TIME_")
	@ApiModelProperty(value = "创建时间")
	protected LocalDateTime createTime;

	@XmlAttribute(name = "createOrgId")
	@TableField("CREATE_ORG_ID_")
	@ApiModelProperty(value = "创建人部门id")
	protected String createOrgId;

	@XmlAttribute(name = "updateBy")
	@TableField("UPDATE_BY_")
	@ApiModelProperty(value = "更新人")
	protected String updateBy;

	@XmlAttribute(name = "updateTime")
	@TableField("UPDATE_TIME_")
	@ApiModelProperty(value = "更新时间")
	protected LocalDateTime updateTime;

	@XmlAttribute(name = "tenantId")
	@TableField("TENANT_ID_")
	@ApiModelProperty(value = "租户id")
	protected String tenantId;
	
	/**
	 * 条件列的控件类型：select：下拉框、dialog：对话框
	 */
	@XmlAttribute(name = "ctrlType")
	@TableField("CTRL_TYPE_")
	@ApiModelProperty(value = "控件类型")
	protected String ctrlType;
	/**
	 * 条件列的关联查询alias
	 */
	@XmlAttribute(name = "queryAlias")
	@TableField("QUERY_ALIAS_")
	@ApiModelProperty(value = "关联查询alias")
	protected String queryAlias;
	
	/**
	 * 条件列的回填key的绑定值
	 */
	@XmlAttribute(name = "bindKey")
	@TableField("BIND_KEY_")
	@ApiModelProperty(value = "条件列的回填key的绑定值")
	protected String bindKey;
	/**
	 * 条件列的回填value的绑定值
	 */
	@XmlAttribute(name = "bindValue")
	@TableField("BIND_VALUE_")
	@ApiModelProperty(value = "条件列的回填value的绑定值")
	protected String bindValue;
	
	/**
	 * 排序
	 */
	@XmlAttribute(name = "sn")
	@TableField("SN_")
	@ApiModelProperty(value = "排序")
	protected Integer sn;

	public void setId(String id) {
		this.id = id;
	}

	/**
	 * 返回 主键
	 * 
	 * @return
	 */
	public String getId() {
		return this.id;
	}

	public void setMatrixId(String matrixId) {
		this.matrixId = matrixId;
	}

	/**
	 * 返回 所属矩阵ID
	 * 
	 * @return
	 */
	public String getMatrixId() {
		return this.matrixId;
	}

	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * 返回 列字段名
	 * 
	 * @return
	 */
	public String getCode() {
		return this.code;
	}

	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 返回 列中文名
	 * 
	 * @return
	 */
	public String getName() {
		return this.name;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	/**
	 * 返回 列状态：0未创建列、1已创建列
	 * 
	 * @return
	 */
	public Integer getStatus() {
		return this.status;
	}

	public void setColType(Integer colType) {
		this.colType = colType;
	}

	/**
	 * 返回 列类型：1条件列、2角色列
	 * 
	 * @return
	 */
	public Integer getColType() {
		return this.colType;
	}

	public void setSelectType(Integer selectType) {
		this.selectType = selectType;
	}

	/**
	 * 返回 选择类型：1单选、2多选
	 * 
	 * @return
	 */
	public Integer getSelectType() {
		return this.selectType;
	}

	public void setColConfig(String colConfig) {
		this.colConfig = colConfig;
	}

	/**
	 * 返回 列配置信息
	 * 
	 * @return
	 */
	public String getColConfig() {
		return this.colConfig;
	}

	public void setIsDele(Integer isDele) {
		this.isDele = isDele;
	}

	/**
	 * 返回 是否删除：0未删、1已删
	 * 
	 * @return
	 */
	public Integer getIsDele() {
		return this.isDele;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	/**
	 * 返回 创建人
	 * 
	 * @return
	 */
	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateTime(LocalDateTime createTime) {
		this.createTime = createTime;
	}

	/**
	 * 返回 创建时间
	 * 
	 * @return
	 */
	public LocalDateTime getCreateTime() {
		return this.createTime;
	}

	public void setCreateOrgId(String createOrgId) {
		this.createOrgId = createOrgId;
	}

	/**
	 * 返回 创建人部门id
	 * 
	 * @return
	 */
	public String getCreateOrgId() {
		return this.createOrgId;
	}

	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

	/**
	 * 返回 更新人
	 * 
	 * @return
	 */
	public String getUpdateBy() {
		return this.updateBy;
	}

	public void setUpdateTime(LocalDateTime updateTime) {
		this.updateTime = updateTime;
	}

	/**
	 * 返回 更新时间
	 * 
	 * @return
	 */
	public LocalDateTime getUpdateTime() {
		return this.updateTime;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getCtrlType() {
		return this.ctrlType; 
	}

	public void setCtrlType(String ctrlType) {
		this.ctrlType = ctrlType;
	}

	public String getQueryAlias() {
		return this.queryAlias;
	}

	public void setQueryAlias(String queryAlias) {
		this.queryAlias = queryAlias;
	}

	/**
	 * 返回 租户id
	 * 
	 * @return
	 */
	public String getTenantId() {
		return this.tenantId;
	}

	public String getBindKey() {
		return bindKey;
	}

	public void setBindKey(String bindKey) {
		this.bindKey = bindKey;
	}

	public String getBindValue() {
		return bindValue;
	}

	public void setBindValue(String bindValue) {
		this.bindValue = bindValue;
	}

	public Integer getSn() {
		return sn;
	}

	public void setSn(Integer sn) {
		this.sn = sn;
	}

	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this).append("id", this.id).append("matrixId", this.matrixId)
				.append("code", this.code).append("name", this.name).append("status", this.status)
				.append("colType", this.colType).append("selectType", this.selectType)
				.append("colConfig", this.colConfig).append("isDele", this.isDele).append("createBy", this.createBy)
				.append("createTime", this.createTime).append("createOrgId", this.createOrgId)
				.append("updateBy", this.updateBy).append("updateTime", this.updateTime)
				.append("tenantId", this.tenantId).toString();
	}
}