package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.model.ExcelTemp;
import com.artfess.sysConfig.model.ExcelTempFields;
import com.artfess.sysConfig.persistence.dao.ExcelTempDao;
import com.artfess.sysConfig.persistence.manager.ExcelTempFieldsManager;
import com.artfess.sysConfig.persistence.manager.ExcelTempManager;
import com.artfess.sysConfig.vo.ExcelTempVo;
import com.artfess.sysConfig.vo.TableFieldVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 导入导出模板
 *
 * @author wh
 * @company rzx
 * @since 2021-08-04
 */
@Service("excelTempManager")
public class ExcelTempManagerImpl extends BaseManagerImpl<ExcelTempDao, ExcelTemp> implements ExcelTempManager {

    @Resource
    ExcelTempDao excelTempDao;

    @Resource
    ExcelTempFieldsManager excelTempFieldsManager;

    //默认查询的数据库
    @Value("${plat.database}")
    private String dataBase;

    //默认数据库类型
    @Value("${plat.db-type}")
    private String dbType;

    public ExcelTemp getExcelTempByTempFiles(String tempFile){
        QueryWrapper<ExcelTemp> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TEMP_FILES",tempFile);
        return this.getOne(queryWrapper);
    }

    public ExcelTemp getExcelTempByBizCode(String bizCode){
        QueryWrapper<ExcelTemp> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("BIZ_CODE",bizCode);
        return this.getOne(queryWrapper);
    }

    //保存模板和字段配置
    @Transactional
    public void save(ExcelTempVo vo){

//        try {
            if (StringUtils.isBlank(vo.getExcelTemp().getId())) {

                ExcelTemp template = getTempByCode(vo.getExcelTemp().getBizCode(), vo.getExcelTemp().getType());
                if (template != null) {
                    throw new ApplicationException("编码已经存在");
                }
                //保存基本信息
                this.save(vo.getExcelTemp());
                List<ExcelTempFields> fields = vo.getFields();
                //保存字段信息
                if (fields.size() > 0) {

                    for (ExcelTempFields p : fields) {
                        p.setTempId(vo.getExcelTemp().getId());
                    }
                    this.excelTempFieldsManager.saveOrUpdateBatch(fields, 10);
                }
            } else {
                //保存基本信息
                this.update(vo.getExcelTemp());

                List<ExcelTempFields> fields = vo.getFields();
                //保存分组人员信息
                if (vo.getFields().size() > 0) {
                    for (ExcelTempFields p : fields) {
                        p.setTempId(vo.getExcelTemp().getId());
                    }
                    this.excelTempFieldsManager.saveOrUpdateBatch(fields, 10);
                }
            }
//        }catch (Exception e){
//            e.printStackTrace();
//        }
    }

    //批量删除
    @Transactional
    public void remove(String ids){
        List<String> list=Arrays.asList(ids.split(","));
        QueryWrapper<ExcelTemp> queryWrapper=new QueryWrapper<>();
        queryWrapper.in("TEMP_ID",list);
        excelTempFieldsManager.remove(queryWrapper);

        this.removeByIds(list);
    }

    public ExcelTempVo getExcelTempById(String id){
        ExcelTempVo vo=new ExcelTempVo();
        vo.setExcelTemp(this.getById(id));
        vo.setFields(this.excelTempFieldsManager.getExcelTempByeTempId(id));
        return vo;
    }

    public ExcelTempVo getExcelTempByCode(String code,Integer type){
        if(StringUtils.isEmpty(code)){
            return null;
        }
        ExcelTemp template=getTempByCode(code,type);
        if(template==null){
            return null;
        }
        ExcelTempVo vo = new ExcelTempVo();
        vo.setFields(excelTempFieldsManager.getExcelTempByeTempId(template.getId()));
        vo.setExcelTemp(template);
        return vo;
    }

    public ExcelTemp getTempByCode(String code,Integer type){
        QueryWrapper<ExcelTemp> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("biz_code",code);
        queryWrapper.eq("type",type);
        return this.getOne(queryWrapper);
    }

    //查询数据库的表和字段
    public List<TableFieldVo> getDataBaseField(String databaseId,String tableSchema, String tableName){
        if(tableSchema.isEmpty()){
            tableSchema=dataBase;
        }
        if("postgresql".equals(dbType)){
            return this.excelTempDao.getPostgreSQLField(tableSchema,tableName);
        } else if("mysql".equals(dbType)) {
            return this.excelTempDao.getMySqlField(tableSchema, tableName);
        }
        return null;
    }
}
