package com.artfess.application.controller;

import com.artfess.application.manager.SysMemberLogsManager;
import com.artfess.application.model.SysMemberLogs;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 
 * <pre> 
 * 描述：系统三员日志 控制器类
 * 构建组：artfess
 * 作者:baseli
 * </pre>
 */
@RestController
@RequestMapping(value="/logs/sysMemberLogs/v1")
@Api(tags="系统三员日志")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
class SysMemberLogsController extends BaseController<SysMemberLogsManager, SysMemberLogs> {
	@Resource
	SysMemberLogsManager sysMemberLogsManager;
	
	/**
	 * 系统操作日志列表(分页条件查询)数据
	 * @param
	 * @return
	 * @throws Exception 
	 * PageJson
	 * @exception 
	 */
	@PostMapping(value="/list",produces = { "application/json; charset=utf-8" })
	@ApiOperation(value="查询三员日志列表", httpMethod = "POST", notes = "查询三员日志列表")
	public PageList<SysMemberLogs> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter<SysMemberLogs> queryFilter) throws Exception{
		return sysMemberLogsManager.query(queryFilter);
	}
	
	/**
	 * 系统操作日志明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/get/{id}")
	@ApiOperation(value="根据ID查询三员日志信息", notes = "根据ID查询三员日志信息")
	public SysMemberLogs get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
		return sysMemberLogsManager.get(id);
	}
	
    /**
	 * 新增系统操作日志
	 * @param sysMemberLogs
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value="添加/修改三员日志信息", notes = "添加/修改三员日志信息")
	public CommonResult<String> save(@ApiParam(name="sysLogs",value="系统系统三员日志对象", required = true)@RequestBody SysMemberLogs sysMemberLogs) throws Exception{
		String msg = "添加系统三员日志成功";
		if(StringUtil.isEmpty(sysMemberLogs.getId())){
			sysMemberLogsManager.create(sysMemberLogs);
		}else{
			sysMemberLogsManager.update(sysMemberLogs);
			 msg = "更新系统三员日志成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 删除系统操作日志记录
	 * @param id
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="remove/{id}")
	@ApiOperation(value="删除三员日志信息", notes = "删除三员日志信息")
	public  CommonResult<String>  remove(@ApiParam(name="id",value="业务主键", required = true)@PathVariable String id) throws Exception{
		sysMemberLogsManager.remove(id);
		return new CommonResult<String>(true, "删除成功");
	}
	
	/**
	 * 批量删除系统操作日志记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/removes")
	@ApiOperation(value="批量删除三员日志信息", notes = "批量删除三员日志信息")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		sysMemberLogsManager.removeByIds(ids);
		return new CommonResult<String>(true, "删除成功");
	}
}
