package com.artfess.sysConfig.persistence.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.artfess.base.jaxb.LocalDateTimeAdapter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 应用参数
 *
 * @company 广州宏天软件股份有限公司
 * @author zst
 * @since 2020-10-13
 */
@XmlRootElement(name = "portalAppParam")
@XmlAccessorType(XmlAccessType.FIELD)
@ApiModel(value="PortalAppParam对象", description="应用参数")
public class PortalAppParam extends BaseModel<PortalAppParam> {

    private static final long serialVersionUID = 1L;

    @XmlTransient
    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @XmlAttribute(name = "name")
    @ApiModelProperty(value = "参数名称")
    @TableField("NAME_")
    private String name;

    @XmlAttribute(name = "alias")
    @ApiModelProperty(value = "参数编码")
    @TableField("ALIAS_")
    private String alias;

    @XmlAttribute(name = "controlType")
    @ApiModelProperty(value = "控件类型")
    @TableField("CONTROL_TYPE_")
    private String controlType;

    @XmlAttribute(name = "value")
    @ApiModelProperty(value = "参数值")
    @TableField("VALUE_")
    private String value;

    @XmlTransient
    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @XmlAttribute(name = "createTime")
    @XmlJavaTypeAdapter(LocalDateTimeAdapter.class)
    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @XmlTransient
    @ApiModelProperty(value = "应用ID")
    @TableField("APP_ID_")
    private String appId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
    public String getControlType() {
        return controlType;
    }

    public void setControlType(String controlType) {
        this.controlType = controlType;
    }
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PortalAppParam{" +
            "id=" + id +
            ", name=" + name +
            ", alias=" + alias +
            ", controlType=" + controlType +
            ", value=" + value +
            ", tenantId=" + tenantId +
            ", createTime=" + createTime +
            ", appId=" + appId +
        "}";
    }
}
