package com.artfess.sysConfig.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 导入导出模板-字段表
 *
 * @author wh
 * @company rzx
 * @since 2021-08-04
 */
@ApiModel(value = "导入导出模板-字段表 （PORTAL_EXCEL_TEMP_FIELDS）", description = "导入导出模板-字段表")
@TableName("PORTAL_EXCEL_TEMP_FIELDS")
public class ExcelTempFields extends BaseModel<ExcelTempFields> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_")
    private String id;

    @ApiModelProperty(value = "模板配置_ID")
    @TableField("TEMP_ID")
    private String tempId;

    @ApiModelProperty(value = "类型（1：导出  2：导入）")
    @TableField("TYPE")
    private Integer type;

    @ApiModelProperty(value = "字段列名")
    @TableField("FIELD_NAME")
    private String fieldName;

    @ApiModelProperty(value = "字段注释")
    @TableField("FIELD_COMMENTS")
    private String fieldComments;

    @ApiModelProperty(value = "数据类型（字符串\\数字\\日期）")
    @TableField("FIELD_TYPE")
    private String fieldType;


    @ApiModelProperty(value = "字段显示值（1：原始值 2：格式化值）")
    @TableField("FIELD_VIEW_TYPE")
    private String fieldViewType;

    @ApiModelProperty(value = "字段数据格式化JSON")
    @TableField("FIELD_DATA_JSON")
    private String fieldDataJson;

    @ApiModelProperty(value = "排序号")
    @TableField("ORDER_INDEX")
    private Integer orderIndex;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTempId() {
        return tempId;
    }

    public void setTempId(String tempId) {
        this.tempId = tempId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldComments() {
        return fieldComments;
    }

    public void setFieldComments(String fieldComments) {
        this.fieldComments = fieldComments;
    }

    public String getFieldType() {
        return fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldViewType() {
        return fieldViewType;
    }

    public void setFieldViewType(String fieldViewType) {
        this.fieldViewType = fieldViewType;
    }

    public String getFieldDataJson() {
        return fieldDataJson;
    }

    public void setFieldDataJson(String fieldDataJson) {
        this.fieldDataJson = fieldDataJson;
    }

    public Integer getOrderIndex() {
        return orderIndex;
    }

    public void setOrderIndex(Integer orderIndex) {
        this.orderIndex = orderIndex;
    }
}
