package com.artfess.xqxt.meeting.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会议议题投票表
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-11-03
 */

@Data
@TableName("biz_meeting_vote")
@ApiModel(value = "BizMeetingVote对象", description = "会议议题投票表")
public class BizMeetingVote extends BizNoModel<BizMeetingVote> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "问题id")
    @TableField("QUESTION_ID_")
    private String questionId;

    @ApiModelProperty(value = "选项id，多选题用【,】隔开")
    @TableField("OPTION_ID_")
    private String optionId;

    @ApiModelProperty(value = "选项id值，多选题用【,】隔开")
    @TableField(exist = false)
    private String optionValue;

    @ApiModelProperty(value = "用户id，不传默认当前用户")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "用户姓名，不传默认当前用户")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "用户账号，不传默认当前用户")
    @TableField("USER_ACCOUNT_")
    private String userAccount;

    @ApiModelProperty(value = "投票主题id")
    @TableField(exist = false)
    private String topicId;

}
