package com.artfess.xqxt.meeting.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 会议问题选项表
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-11-03
 */

@Data
@TableName("biz_meeting_option")
@ApiModel(value = "BizMeetingOption对象", description = "会议问题选项表")
public class BizMeetingOption extends BizNoModel<BizMeetingOption> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "问题ID，关联问题表ID")
    @TableField("QUESTION_ID_")
    private String questionId;

    @ApiModelProperty(value = "选项")
    @TableField("OPTION_VALUE_")
    private String optionValue;

    @ApiModelProperty(value = "选项类型（1：单选题:2：多选题）")
    @TableField("OPTION_TYPE_")
    private String optionType;

    @ApiModelProperty("选项投票占比")
    @TableField(exist = false)
    private BigDecimal proportion;

    @ApiModelProperty("票数")
    @TableField(exist = false)
    private Integer poll;

}
