package com.artfess.xqxt.meeting.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.xqxt.meeting.manager.BizMeetingPlaceNameManager;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.model.BizMeetingPlaceName;
import com.artfess.xqxt.meeting.model.BizSiteParamEx;
import com.artfess.xqxt.meeting.model.Meeting;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 *  前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-08-05
 */
@RestController
@RequestMapping("/bizMeetingPlaceName/v1/")
@Api(tags = "会议室分组模块")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMeetingPlaceNameController extends BaseController<BizMeetingPlaceNameManager, BizMeetingPlaceName> {

    @RequestMapping(value = "/getJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "会议室查询", httpMethod = "POST")
    public CommonResult<List<BizMeetingPlaceName>> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizMeetingPlaceName> queryFilter) {
        return new CommonResult<List<BizMeetingPlaceName>>
                (true, "数据查询成功", baseService.queryNoPage(queryFilter));
    }

}
