/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.sysConfig.model.ExcelTemp;
import com.artfess.sysConfig.persistence.manager.ExcelTempFieldsManager;
import com.artfess.sysConfig.persistence.manager.ExcelTempManager;
import com.artfess.sysConfig.vo.ExcelTempVo;
import com.artfess.sysConfig.vo.TableFieldVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/excel/v1"})
@Api(tags={"\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f\u7ba1\u7406"})
@ApiGroup(group={"group_application"})
public class ExcelTempController
extends BaseController<ExcelTempManager, ExcelTemp> {
    @Resource
    ExcelTempManager excelTempManager;
    @Resource
    ExcelTempFieldsManager excelTempFieldsManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<ExcelTemp> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.excelTempManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6a21\u677f\u5bf9\u8c61\u8be6\u60c5", httpMethod="GET", notes="\u6a21\u677f\u5bf9\u8c61\u8be6\u60c5")
    public ExcelTempVo getJson(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        return this.excelTempManager.getExcelTempById(id);
    }

    @RequestMapping(value={"getJsonByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u6a21\u677f\u5bf9\u8c61\u8be6\u60c5", httpMethod="GET", notes="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u6a21\u677f\u5bf9\u8c61\u8be6\u60c5")
    public ExcelTempVo getJsonByCode(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String code, @ApiParam(name="type", value="\u6a21\u677f\u7c7b\u578b") Integer type) throws Exception {
        return this.excelTempManager.getExcelTempByCode(code, type);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u4fe1\u606f")
    public CommonResult save(@ApiParam(name="catalog", value="\u6a21\u677f\u5bf9\u8c61") @RequestBody ExcelTempVo vo) throws Exception {
        try {
            this.excelTempManager.save(vo);
            return new CommonResult("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6a21\u677f", httpMethod="DELETE", notes="\u5220\u9664\u6a21\u677f")
    public CommonResult remove(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String ids) throws Exception {
        try {
            this.excelTempManager.removeByIds(new String[]{ids});
            return new CommonResult("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getDataBaseField"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bfc\u5165\u6a21\u677f\u9009\u62e9\u6570\u636e\u8868\u548c\u5b57\u6bb5", httpMethod="POST", notes="\u81ea\u5b9a\u4e49\u5bfc\u5165\u6a21\u677f\u9009\u62e9\u6570\u636e\u8868\u548c\u5b57\u6bb5")
    public List<TableFieldVo> getDataBaseField(@ApiParam(name="dataBaseId", value="\u6570\u636e\u6e90ID") @RequestParam String dataBaseId, @ApiParam(name="tableSchema", value="\u6570\u636e\u5e93") @RequestParam String tableSchema, @ApiParam(name="tableName", value="\u6570\u636e\u8868") @RequestParam String tableName) throws Exception {
        return this.excelTempManager.getDataBaseField(dataBaseId, tableSchema, tableName);
    }

    @RequestMapping(value={"removeField"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6a21\u677f\u5b57\u6bb5", httpMethod="DELETE", notes="\u5220\u9664\u6a21\u677f\u5b57\u6bb5")
    public CommonResult removeField(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        try {
            this.excelTempFieldsManager.removeById((Serializable)((Object)id));
            return new CommonResult("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"checkTemp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u662f\u5426\u6709\u6a21\u7248", httpMethod="POST", notes="\u9a8c\u8bc1\u662f\u5426\u6709\u6a21\u7248")
    public ExcelTempVo checkTemp(@ApiParam(name="bizCode", value="\u7f16\u7801") @RequestParam String bizCode, @ApiParam(name="type", value="\u5bfc\u5165\u5bfc\u51fa\u7c7b\u578b") @RequestParam Integer type) throws Exception {
        ExcelTempVo vo = this.excelTempManager.getExcelTempByCode(bizCode, type);
        return vo;
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u901a\u7528\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u6d4b\u8bd5")
    public CommonResult msgUpload(@RequestBody MultipartFile file) {
        return new CommonResult("\u6210\u529f");
    }
}

