### demo

```
<import-data
    tempFiles="消息分类导入模板"
    bizCode="messageClassification"
    :dataBaseOptions="dataBaseOptions"
    :originAPIOptions="originAPIOptions"
></import-data>

<export-data
    tempFiles="消息分类导出模板"
    bizCode="messageClassification"
    :dataBaseOptions="dataBaseOptions"
    :originAPIOptions="originAPIOptions"
    :exportQuery="exportQuery"
></export-data>

data(){
    return {
        dataBaseOptions: {
            dataBaseId: '',
            tableName: 'portal_sys_msg_type', // 必填
            tableSchema: '',
        },
        originAPIOptions: {
            url: '/msg/messageType/v1/query', // 列表请求接口地址
            method: 'post',            // 列表请求方法
            moduleRoot: 'portal',  // 微服务根路径
        },
        exportQuery:{}
    }
},
methods(){
    loadData(param, cb) {
        if (!param) {
            this.pageBean.total = 0
            param = {pageBean: ''}
            param.pageBean = this.pageBean
            param.sorter = this.defaultSort
        }
        this.exportQuery = param
        flow.getMsgClassificationData(param)
            .then((resp) => {
                this.data = resp.data.rows
                this.pageBean = {
                    page: resp.data.page,
                    pageSize: resp.data.pageSize,
                    total: resp.data.total,
                }
            })
            .finally(() => cb())
    },

}
```

 ### import-data API
|  参数   | 说明  | 类型 | 可选值 |	默认值 | 是否必须 | 
|  ----  |  ----  |  ----  |  ----  |  ----  |  ----  | 
| bizCode | 当前组件在菜单中的别名 | String |  -   |   -   |  是  | 
| tempFiles | 导入模板文件名称 | String |  -   |   -   |  是  | 
| originAPIOptions | 当前页面数据所在数据库名 | Object |  -   |   -   |  是  |
| dataBaseOptions | 数据源、数据库、表名 | Object |  -   |   -   |  是  |
 
 ### export-data API
|  参数   | 说明  | 类型 | 可选值 |	默认值 | 是否必须 | 
|  ----  |  ----  |  ----  |  ----  |  ----  |  ----  | 
| bizCode | 当前组件在菜单中的别名 | String |  -   |   -   |  是  | 
| tempFiles | 导出模板文件名称 | String |  -   |   -   |  是  | 
| originAPIOptions | 当前页面数据所在数据库名 | Object |  -   |   -   |  是  |
| dataBaseOptions | 数据源、数据库、表名 | Object |  -   |   -   |  是  |
| exportQuery | 当前页面表格请求参数 | Object |  -   |   -   |  否  |
