import { defineComponent, reactive, computed, onBeforeMount,onMounted, watch } from 'vue'
import * as echarts from 'echarts'
import { baseYAxis, baseSeriesConfig, initColor, paramsExample } from './base_config'
import Empty from '@/components/empty.vue'
let idx =1
export default defineComponent({
  props: {
    datas: {
      type: Object,
      default: () => (paramsExample)
    },
  },
  setup(props) {
    const state = reactive<any>({
      chartId: '',
      height: '200px',
      noData: false,
    })

    // 初始化
    let myChart:any = null
    const initChart = () =>{
      const dom = document.getElementById(state.chartId)
      if (!dom) {
        return
      }
      myChart = echarts.init(dom)
    }
    const handleData = () => {
      const { data } = props.datas
      const { startColor, endColor } = initColor(data)
      const series:any = []
      let yAxisList:any = []
      data.map((item:any, index:number) => {
        if (item.showYAxis) {
          const min = Math.min.apply(null, item.value)
          const max = Math.max.apply(null, item.value)
          yAxisList.push({
            ...baseYAxis,
            ...{
              name: item.yAxisName,
              position: item.position || 'left',
              min: Math.floor((min - min * 0.1) / 10) * 10,
              max: Math.ceil((max + max * 0.1) / 10) * 10,
            },
          })
        }
        let baseType = baseSeriesConfig['line']
        if(item.type && baseSeriesConfig[item.type]) {
          baseType = baseSeriesConfig[item.type]
        }
        const baseSeries = baseType(startColor[item.useColorIndex || index], endColor[item.useColorIndex || index])
        series.push({
          name: item.name,
          yAxisIndex: item.showYAxis ? yAxisList.length - 1 : 0,
          ...baseSeries,
          data: item.value,
        })
      })
      yAxisList = yAxisList.length === 0 ? [{...baseYAxis, name: props.datas.yAxisName}] : yAxisList
      return { series, yAxisList }
    }
    const setChatOption = () => {
      const datas = props.datas
      if (!datas || !Object.keys(datas).length || !datas.data || !datas.data.length) {
        state.noData = true
        myChart && myChart.clear()
        return
      }
      state.noData = false
      const { title ,xAxisData} = datas
      const { series, yAxisList } = handleData()
      const options = {
        title: {
          show: title,
          text: title,
          left: 'center',
          textStyle: {
            color: '#ffffff',
            fontSize: 14,
            lineHeight: 20,
          },
        },
        grid: {
          top: 70,
          left: 17,
          right: 17,
          bottom: 10,
          containLabel: true,
        },
        tooltip: {
          trigger: 'axis',
          backgroundColor: 'rgba(50, 50, 50, 0.7)',
          borderColor: 'rgb(51, 51, 51)',
          textStyle: {
            color: 'rgb(255, 255, 255)',
          },
          axisPointer: {
            lineStyle: {
              color: {
                type: 'linear',
                x: 0,
                y: 0,
                x2: 0,
                y2: 1,
                colorStops: [
                  {
                    offset: 0,
                    color: 'rgba(255,255,255,0)', // 0% 处的颜色
                  },
                  {
                    offset: 0.5,
                    color: 'rgba(255,255,255,1)', // 100% 处的颜色
                  },
                  {
                    offset: 1,
                    color: 'rgba(195,255,250,1)', // 100% 处的颜色
                  },
                ],
                global: false, // 缺省为 false
              },
            },
          },
        },
        dataZoom: [
          {
            type: 'inside',
            start: 0,
            end: 100,
          },
        ],
        legend: {
          orient: 'horizontal',
          left: 'right',
          top: title ? 22 : 5,
          textStyle: {
            fontSize: 12,
            color: '#C3E1FA',
            height: 8,
            rich: {
              a: {
                verticalAlign: 'bottom',
              },
            },
          },
        },
        xAxis: [
          {
            type: 'category',
            boundaryGap: false,
            axisLine: {
              //坐标轴轴线相关设置
              show: true,
              lineStyle: {
                color: '#778FA4',
              },
            },
            axisLabel: {
              //坐标轴刻度标签的相关设置
              color: '#9BABBA',
              fontSize: 10,
              align: 'center',
            },
            axisTick: {
              show: false,
            },
            data: xAxisData,
          },
        ],
        yAxis: yAxisList,
        series: series
      }
      !myChart && initChart()
      myChart && myChart.clear()
      myChart && myChart.setOption(options)
    }

    watch(() => props.datas, () => {
      setChatOption()
    }, {deep: true})
    onBeforeMount(() => {
      state.height = props.datas.height || state.height
      state.chartId = `baseChart_${idx++}`
    })
    onMounted(()=> {
      setChatOption()
    })
    return () => (
      <>
        <div v-show={!state.noData} style={{'height': state.height}} id={state.chartId}></div>
        <div v-show={state.noData} style={{'height': state.height}} class="relative">
          <Empty />
        </div>
      </>
    )
  }
})
