import { defineComponent, reactive, computed, onBeforeMount,onMounted, watch } from 'vue'
import * as echarts from 'echarts'
import { paramsExample, getColor, placeHolderStyle, dataStyle } from './ring_config'
import Empty from '@/components/empty.vue'
let idx =1
export default defineComponent({
  props: {
    datas: {
      type: Object,
      default: () => ({paramsExample})
    },
  },
  setup(props) {
    const state = reactive<any>({
      chartId: '',
      height: '100px',
      width: '100px',
      noData: false,
    })

    // 初始化
    let myChart:any = null
    const initChart = () =>{
      const dom= document.getElementById(state.chartId)
      if (!dom) {
        return
      }
      myChart = echarts.init(dom)
    }
    const setChatOption = () => {
      const {datas} = props
      if (!datas || !datas.value) {
        state.noData = true
        myChart && myChart.clear()
        return
      }
      state.noData = false
      const { title ,value, useColorIndex} = datas
      const { startColor, endColor } = getColor(useColorIndex)
      const options = {
        title: {
          show: title,
          text: title + ' ',
          left: '50%',
          top: '80%',
          textAlign: 'center',
          textStyle: {
            fontWeight: 'normal',
            fontSize: '15',
            color: '#fff',
            textAlign: 'center',
          },
        },
        series: [
          // 阴影
          {
            type: 'pie',
            hoverAnimation: false, //鼠标经过的特效
            radius: ['78%', '90%'],
            center: ['50%', '50%'],
            startAngle: 225,
            labelLine: {
              normal: {
                  show: false
              }
            },
            label: {
              normal: {
                position: 'center'
              }
            },
            data: [
              {
                value: Number(value) > 75 ? value : 75,
                itemStyle: {
                  normal: {
                    color: ['rgba(176, 212, 251, 0.3)']
                  }
                },
              },
              {
                value: 25,
                itemStyle: placeHolderStyle,
              },
            ]
          },
          // 边框
          {
            type: 'pie',
            hoverAnimation: false, //鼠标经过的特效
            radius: ['90%', '93%'],
            center: ['50%', '50%'],
            startAngle: 225,
            labelLine: {
              normal: {
                  show: false
              }
            },
            label: {
              normal: {
                position: 'center'
              }
            },
            data: [
              {
                value: Number(value) > 75 ? value : 75,
                itemStyle: {
                  normal: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                      "offset": 0,
                      "color": endColor
                    }, {
                      "offset": 1,
                      "color": startColor
                    }]),
                  }
                },
              },
              {
                value: 25,
                itemStyle: placeHolderStyle,
              },
            ]
          },
          // 数值
          {
            type: 'pie',
            hoverAnimation: false, //鼠标经过的特效
            radius: ['78%', '90%'],
            center: ['50%', '50%'],
            startAngle: 225,
            labelLine: {
              normal: {
                show: false
              }
            },
            label: {
              normal: {
                position: 'center'
              }
            },
            data: [
              {
                value: value * 0.5,
                itemStyle: {
                  normal: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                      "offset": 0,
                      "color": startColor
                    }, {
                      "offset": 1,
                      "color": endColor
                    }]),
                  }
                },
                label: {
                  normal: {
                    ...dataStyle.normal,
                    formatter: (params:any) => params.value/0.5 + '%',
                  }
                },
              },
              {
                value: 25,
                itemStyle: placeHolderStyle,
              },
            ]
          },
        ]
      }
      !myChart && initChart()
      myChart && myChart.setOption(options)
    }

    watch(() => props.datas, () => {
      setChatOption()
    }, {deep: true})
    onBeforeMount(() => {
      state.height = props.datas.height || state.height
      state.width = props.datas.width || state.width
      state.chartId = `ringChart_${idx++}`
    })
    onMounted(()=> {
      setChatOption()
    })
    return () => (
      <>
        <div v-show={!state.noData} style={{'height': state.height, 'width': state.width}} id={state.chartId}></div>
        <div v-show={state.noData} style={{'height': state.height, 'width': state.width}} class="relative">
          <Empty />
        </div>
      </>
    )
  }
})
