import type { Ref } from 'vue';
import type { BaseOptions, BaseResult, FormatOptions, FRPlaceholderType } from './core/types';
import type { IService } from './core/utils/types';
export interface RequestResult<R, P extends unknown[]> extends Omit<BaseResult<R, P>, 'reset'> {
    reloading: Ref<boolean>;
    reload: () => void;
}
declare function useRequest<R, P extends unknown[] = any>(service: IService<R, P>): RequestResult<R, P>;
declare function useRequest<R, P extends unknown[] = any, FR = FRPlaceholderType>(service: IService<R, P>, options: FormatOptions<R, P, FR>): RequestResult<FR, P>;
declare function useRequest<R, P extends unknown[] = any>(service: IService<R, P>, options: BaseOptions<R, P>): RequestResult<R, P>;
export default useRequest;
