import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    // 分页查询
    // getSurveyList(pamars,cb) {
    // 	req.post(portal + `/biz/bizReformSatisfactionManagement/v1/page`, pamars).then(res => {
    // 		cb(res.data)
    // 	})
    // },
    // 专员查询
    getSurveyList(data, cb) {
        req.post(portal + `/biz/bizReformSatisfactionManagement/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 满意度审核查询
    getSurveyList1(data, cb) {
        req.post(portal + `/biz/bizReformSatisfactionManagement/v1/auditQuery`, data).then(res => {
            cb(res.data)
        })
    },
    // 满意度确认
    getSurveyList2(data, cb) {
        req.post(portal + `/biz/bizReformSatisfactionManagement/v1/reformQuery`, data).then(res => {
            cb(res.data)
        })
    },
    // 新增、修改
    addSurvey(data, cb) {
        req.post(portal + `/biz/bizReformSatisfactionManagement/v1/saveOrUpdateSatisfaction`, data).then(res => {
            cb(res.data)
        })
    },
    // 删除
    deleteSurvey(ids, cb) {
        req.post(portal + `/biz/bizReformSatisfactionManagement/v1/delete?id=${ids}`).then(res => {
            cb(res.data)
        })
    },
    // 查询所有区县
    getDistrictList(cb) {
        req.get(portal + `/api/org/v1/selectQx`).then(res => {
            cb(res.data)
        })
    },
    // 满意度审核
    auditById(data, cb) {
        let url = data.status ? `/biz/bizReformSatisfactionManagement/v1/updateStatusById?id=${data.id}&status=${data.status}` :
            `/biz/bizReformSatisfactionManagement/v1/updateStatusById?id=${data.id}&fileStatus=${data.fileStatus}`
        req.post(portal + url).then(res => {
            cb(res.data)
        })
    },
    // 分页查询项目改革满意度管理
    getProjectList(data, cb) {
        req.post(portal + `/fill/bizReformSatisfactionProject/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 删除项目满意度调查
    deleteProject(ids, cb) {
        req.post(portal + `/fill/bizReformSatisfactionProject/v1/delete?id=${ids}`).then(res => {
            cb(res.data)
        })
    },
    // 新增、修改改革项目满意度调查
    addProject(data, cb) {
        req.post(portal + `/fill/bizReformSatisfactionProject/v1/save`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据id查询所有附件信息
    getFileListById(data, cb) {
        req.post(portal + `/file/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据id下载文件
    getDownloadById(id, cb) {
        req.get(portal + `/file/v1/downloadFile?fileId=${id}`).then(res => {
            cb(res.data)
        })
    },
    // 根据id删除附件
    deleteFileById(ids, cb) {
        req.post(portal + `/file/v1/remove`, ids).then(res => {
            cb(res.data)
        })
    },
    // 根据id获取已导入的数据
    getImportDataById(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/biz/reformSatisfaction/districts/detailQuery`,
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 分页查询
    queryByPage(data, status = 'false', cb) {
        req.post(portal + `/biz/bizReformSatisfactionManagement/v1/queryByPage?isAffirm=${status}`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据id查询
    queryById(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/biz/bizReformSatisfactionManagement/v1/queryById`,
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    }

}
