import req from '@/request.js'
const portal = window.context.portal
export default {
    // 数字重庆推进更新
    digitalCQPropel(data, cb) {
        req
            .post(portal + `/fill/bizDigitalConstruction/v1/`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 保存并上报
    saveAndReport(data, cb) {
        req
            .put(portal + `/fill/bizDigitalConstruction/v1/`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县录入查询
    getCreateById(id, cb) {
        req
            .post(portal + `/fill/bizDigitalConstruction/v1/getCreateById`)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县审核查询详情
    getDetailById(id, cb) {
        req
            .post(portal + `/fill/bizDigitalConstruction/v1/getAuditById?id=${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 改革办审核查询详情
    getExamineById(id, cb) {
        req
            .post(portal + `/fill/bizDigitalConstruction/v1/getExamineById?id=${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 历史查询
    getHistoryById(data, cb) {
        let {id,date,isAffirm} = data
        req
            .post(portal + `/fill/bizDigitalConstruction/v1/getHisById?unitId=${id}&date=${date}&isAffirm=${isAffirm}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 列表查询
    getTableData(data, cb) {
        req
            .post(portal + `/fill/bizDigitalConstruction/v1/queryByPage`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id删除一件事数据
    deleteOneById(id, cb) {
        req
            .remove(portal + `/fill/bizDigitalOneThing/v1/${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id删除三张清单数据
    deleteTwoById(id, cb) {
        req
            .remove(portal + `/fill/bizDigitalThreeLists/v1/${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id删除上线应用数据
    deleteThreeById(id, cb) {
        req
            .remove(portal + `/fill/bizDigitalOnLineApplication/v1/${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id删除特色应用数据
    deleteFourById(id, cb) {
        req
            .remove(portal + `/fill/bizDigitalShareApplication/v1/${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 删除附件
    deleteFiles(ids, cb) {
        req.post(portal + `/file/v1/remove`, ids).then(res => {
            cb(res.data)
        })
    },
    // 查询一件事所有数据
    getOneAllData(data, cb) {
        req.post(portal + `/fill/bizDigitalOneThing/v1/queryByPageNew`, data).then(res => {
            cb(res.data)
        })
    },
    // 查询三张清单所有数据
    getTwoAllData(data, cb) {
        req.post(portal + `/fill/bizDigitalThreeLists/v1/queryByPageNew`, data).then(res => {
            cb(res.data)
        })
    },
    // 查询上线应用所有数据
    getThreeAllData(data, cb) {
        req.post(portal + `/fill/bizDigitalOnLineApplication/v1/queryByPageNew`, data).then(res => {
            cb(res.data)
        })
    },
    // 查询特色应用所有数据
    getFourAllData(data, cb) {
        req.post(portal + `/fill/bizDigitalShareApplication/v1/queryByPageNew`, data).then(res => {
            cb(res.data)
        })
    },
    // 判断是否可编辑
    getIsEdit(data, cb) {
        let { id, unitId } = data
        req.post(portal + `/fill/bizDigitalConstruction/v1/invIsNew?id=${id}&unitId=${unitId}`, data).then(res => {
            cb(res.data)
        })
    },
    // 查询一件事全量库所有数据
    getFullLibrary(data, cb) {
        req.post(portal + `/fill/bizDigitalOneThing/v1/queryByPageHis`, data).then(res => {
            cb(res.data)
        })
    },
    // 获取文件列表
    getFiles(data, cb) {
        req.post(portal + '/file/v1/list', data).then(res => {
            cb(res.data)
        })
    },

}