import req from '@/request.js'
const portal = window.context.portal
export default {
    // 基础信息列表查询
    gteBaseInfo(data, cb) {
        req
            .post(portal + `/fill/bizApplicationBase/v1/query`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id查询基础信息
    getBasicInfoById(id, cb) {
        req
            .post(portal + `/fill/bizApplicationBase/v1/findById?id=${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 纳入一本账
    takeIntoAccount(data, cb) {
        req
            .post(portal + `/fill/bizApplicationBase/v1/updateByStatus`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 填报模块分页查询
    getEditPaging(data, isAffirm, cb) {
        req
            .post(portal + `/fill/bizApplicationBase/v1/queryByPage?isAffirm=${isAffirm}`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 专题组分页查询列表
    getGroupList(data, cb) {
        req
            .post(portal + `/fill/bizApplicationBase/v1/queryByGroup`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 新增或修改
    saveOrUpdate(data, cb) {
        req
            .post(portal + `/fill/bizApplicationRecord/v1/saveOrUpdate`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id查询填报信息
    getEditInfoById(id, cb) {
        req
            .post(portal + `/fill/bizApplicationRecord/v1/findById?id=${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id修改审核状态
    updateStatusById(data, cb) {
        req
            .post(portal + `/fill/bizApplicationRecord/v1/updateByStatus`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id删除列表数据
    deleteListById({ id, type, fileId }, cb) {
        req
            .post(portal + `/fill/bizApplicationRecord/v1/deleteByType?id=${id}&type=${type}&fileId=${fileId}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 新闻列表查询 
    getNewsData(data, cb) {
        req
            .post(portal + `/fill/bizApplicationWorkNews/v1/query`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 保存新闻
    saveNewsData(data, cb) {
        req
            .post(portal + `/fill/bizApplicationWorkNews/v1/`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 修改新闻 
    updateNewsData(data, cb) {
        req
            .put(portal + `/fill/bizApplicationWorkNews/v1/`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id删除新闻
    deleteNewById(id, cb) {
        req
            .remove(portal + `/fill/bizApplicationWorkNews/v1/${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 文件库保存
    saveFile(data, cb) {
        req
            .post(portal + `/fill/bizApplicationFile/v1/`, data)
            .then(res => {
                cb(res.data)
            })
    }, 
    // 文件列表查询
    getFileList(data, cb) {
        req
            .post(portal + `/fill/bizApplicationFile/v1/query`, data)
            .then(res => {
                cb(res.data)
            })
    }, 
}