import req from '@/request.js'
const portal = window.context.portal
const task = window.context.task
export default {
  // 新增任务
  addSave(data, cb) {
    req.post(task + `/biz/task/schedulerTask/v1/`, data).then(rep => {
      cb(rep.data)
    })
  },
  // 查询任务
  detailId(id, cb) {
    req.get(task + `/biz/task/schedulerTask/v1/` + id).then(rep => {
      cb(rep.data)
    })
  },
  // 确认修改
    upData(data, cb) {
      req.put(task + `/biz/task/schedulerTask/v1/`, data).then(req=>{
          cb(req.data)
      })
    },
  //启动任务
  startUpJob(ids, cb){
    req.post(task + `/biz/task/schedulerTask/v1/startUpJob?taskId=`+ids).then(rep => {
        cb(rep.data)
      })
  },
  //停止任务
  stopJob(ids, cb){
    req.post(task + `/biz/task/schedulerTask/v1/stopJob?taskId=`+ids).then(rep => {
        cb(rep.data)
      })
  },
  //删除任务
  remove(ids, cb) {
    req.remove(task + `/biz/task/schedulerTask/v1/?ids=` + ids).then(rep => {
      cb(rep.data)
    })
  },
  // 分页查询
  listQuery(data, cb) {
    req.post(task + `/biz/task/schedulerTask/v1/query`, data).then(req => {
      cb(req.data)
    })
  },
  // 获取源表名
  sourceTables(data,cb){
    req.post(portal + `/form/customQuery/v1/getByDsObjectName`, data).then(req => {
      cb(req.data)
    })
  },
  // 验证任务执行
  verification(ids,cb){
    req.get(task + `/job/scheduler/v1/validClass?className=`+ids).then(req => {
      cb(req.data)
    })
  }
}
