import req from '@/request.js'

const portal = window.context.portal
const headers = {
  'Content-type': 'application/x-www-form-urlencoded'
}
export default {
  // 品牌榜
  getProjectBrand(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/queryBrandForProject?year=${data.year}&month=${data.month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 品牌榜 月统计
  getBrandMonthDate(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/brandLineChart?year=${data.year}&month=${data.month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 迭代榜
  getIteration(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/queryIterationForProject?year=${data.year}&month=${data.month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 根据id查询举措列表
  getIterationList(id, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/queryIterationForProjectInfo?projectId=${id}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 竞速榜
  getProjectSpeed(data, cb) {
    req.post(portal + `/bizScoringProjectTarget/v1/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 指标库
  getIndexLibraryOld(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/complianceRateCount?year=${data.year}&month=${data.month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  getIndexLibrary(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/reachRateCount?year=${data.year}&month=${data.month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 查询指标库饼图数据
  getIndexPieChartData(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/reachProjectRateCount?year=${data.year}&month=${data.month}`
      )
      .then(res => {
        cb(res.data)
      })
  },

  // 报表指数
  getRank(data, cb) {
    req
      .request({
        method: 'post',
        url: portal + `/project/largeScreen/v1/indexRank`,
        data,
        headers
      })
      .then(res => {
        cb(res.data)
      })
  },
  // 成果榜 趋势对比
  getResultTrend(data, cb) {
    let {year, month} = data
    req
      .post(
        portal +
          `/project/largeScreen/v1/achievementCount?year=${year}&month=${month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 成果 分类查询
  getResultList(data, cb) {
    req
      .post(portal + `/project/largeScreen/v1/achievementInfo`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 成果榜查询详情
  getResultD(id, cb) {
    req
      .post(portal + `/project/largeScreen/v1/achievementFindById/${id}`)
      .then(res => {
        cb(res.data)
      })
  },
  // 制度成果 分类查询
  getResultZD(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/achievementInvCount?year=${data.year}&month=${data.month}`,
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 主要举措指标
  getNumIndex(cb) {
    req.get(portal + `/bizScoringProjectMeasure/v1/getNumVo`).then(res => {
      cb(res.data)
    })
  },
  // 当月计划完成总览
  getProjectFinish(cb) {
    req.get(portal + `/bizScoringProjectTarget/v1/targetAll`).then(res => {
      cb(res.data)
    })
  },
  // 主要量化目标
  getTargetIndex(cb) {
    req.get(portal + `/bizScoringProjectTarget/v1/target`).then(res => {
      cb(res.data)
    })
  },
  // 三个一批项目库
  getProjectByType(data, cb) {
    req
      .post(
        portal +
          `/majorProjects/municipalMajorProjectManagement/v1/queryProjectList`,
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 量化目标清单
  targetList(data, cb) {
    req
      .request({
        method: 'post',
        url:
          portal +
          `/majorProjects/pilotQuantitativeObjectivesPush/v1/queryTargetList`,
        data,
        headers
      })
      .then(res => {
        cb(res.data)
      })
  },
  // 月度计划清单
  queryMonthPlanList(data, cb) {
    req
      .request({
        method: 'post',
        url:
          portal +
          `/majorProjects/pilotQuantitativeObjectivesPush/v1/queryMonthPlanList`,
        data,
        headers
      })
      .then(res => {
        cb(res.data)
      })
  },
  // 重大项目综合报表
  getReport(data, cb) {
    req
      .request({
        method: 'post',
        url: portal + `/bizScoringProjectSyn/v1/querySynReport`,
        data,
        headers
      })
      .then(res => {
        cb(res.data)
      })
  },
  // 需求热力榜
  getDemandHeatList(data, cb) {
    let {year, month} = data
    req
      .post(
        portal +
          `/project/largeScreen/v1/demandHeatList?year=${year}&month=${month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 需求清单
  getDemandList(data, cb) {
    req
      .post(portal + '/project/largeScreen/v1/demandDetailList', data)
      .then(res => {
        cb(res.data)
      })
  },
  // 获取作战图统计数据
  getBattleChart(data, cb) {
    let {year, month} = data
    req
      .post(
        portal +
          `/project/largeScreen/v1/monthPlanNum?year=${year}&month=${month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 各个项目作战图统计
  getProjectStatistics(data, cb) {
    let {year, month} = data
    req
      .post(
        portal +
          `/project/largeScreen/v1/monthPlanNumForProject?year=${year}&month=${month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 重大项目详情
  getProjectDetailById(data, cb) {
    let {year, month, projectId} = data
    req
      .post(
        portal +
          `/majorProjects/municipalMajorProjectManagement/v1/overAllQuery?projectId=${projectId}&year=${year}&month=${month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 改革动态
  getNews(data, cb) {
    req.post(portal + `/fill/bizWorkNews/v1/queryCode`, data).then(res => {
      cb(res.data)
    })
  },
  // 其他成果列表查询
  getOtherResults(data, cb) {
    let {year, month, projectId} = data
    req
      .post(
        portal +
          `/project/largeScreen/v1/brandForProjectDetails?year=${year}&month=${month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  //三攻坚成果榜
  getThreeResultList(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/difficultyFirstScreen?fillYear=${data.fillYear}&fillMonth=${data.fillMonth}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 详情
  getThreeResultData(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/difficultyFirstScreenDetails?fillYear=${data.fillYear}&fillMonth=${data.fillMonth}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  //三攻坚竞速榜
  getThreeSpeedList(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/difficultySecondScreen?fillYear=${data.fillYear}&fillMonth=${data.fillMonth}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 详情
  getThreeSpeedData(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/difficultySecondScreenDetails?fillYear=${data.fillYear}&fillMonth=${data.fillMonth}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 三攻坚 详情
  getThreeOneData(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/difficultyScreen?year=${data.fillYear}&month=${data.fillMonth}&fillType=${data.fillType}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 三攻坚 导出
  exportThreeOneData(data, cb) {
    req
      .downloadPostCopy(
        portal +
          `/project/largeScreen/v1/difficultyScreenExport?year=${data.fillYear}&month=${data.fillMonth}&fillType=${data.fillType}`
      )
      .then(res => {
        cb(res)
      })
  },
  // 加快实施一批和谋划储备一批数据查询
  getReadyAndPlanningData(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/twoBatch?year=${data.year}&month=${data.month}&projectType=${data.type}&projectCategory=${data.projectCategory}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 专项小组晾晒查询
  getGroupDrying(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/groupField?year=${data.year}&month=${data.month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 专项小组资料查询
  getGroupFile(data, cb) {
    req
      .post(portal + `/project/largeScreen/v1/groupProfileInfo`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 根据id查询附件列表
  getFiles(data, cb) {
    req.post(portal + '/file/v1/list', data).then(res => {
      cb(res.data)
    })
  },
  // 主屏加快实施一批查询
  getTriplicateOneData(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/speedUpBatch?year=${data.year}&month=${data.month}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 改革数据库基本类型数据查询
  getReformDataBase(data, cb) {
    req
      .post(portal + `/project/largeScreen/v1/dataProfileInfo`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 改革数据库改革试点统计数据查询
  getMunicipalPilotStatistics(cb) {
    req.post(portal + `/project/largeScreen/v1/cityPilotCount`).then(res => {
      cb(res.data)
    })
  },
  // 改革数据库改革试点数据查询
  getMunicipalPilotData(data, cb) {
    req
      .post(portal + `/project/largeScreen/v1/cityPilotManagementDetails`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 根据id查询推进信息
  getMunicipalPilotPropel(id, cb) {
    req
      .post(portal + `/project/largeScreen/v1/cityPilotManagementById/${id}`)
      .then(res => {
        cb(res.data)
      })
  },
  // 改革数据库改革需求数据查询
  getReformDemandData(data, cb) {
    req
      .post(
        portal + `/project/largeScreen/v1/demandAnalysisLibraryDetails`,
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 改革数据库改革需求统计数据查询
  getReformDemandStatistics(cb) {
    req.post(portal + `/project/largeScreen/v1/demandCount`).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询详情
  getReformDemandDetails(id, cb) {
    req
      .post(portal + `/project/largeScreen/v1/demandAnalysisLibraryById/${id}`)
      .then(res => {
        cb(res.data)
      })
  },
  // 改革数据库改革成效数据查询
  getEffectOfReformData(data, cb) {
    req
      .post(portal + `/project/largeScreen/v1/cityBrandReformDetails`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 改革数据库改革成效统计数据查询
  getEffectOfReformStatistics(cb) {
    req
      .post(portal + `/project/largeScreen/v1/cityBrandReformCount`)
      .then(res => {
        cb(res.data)
      })
  },
  // 根据id查询详情
  getEffectOfReformDetails(id, cb) {
    req
      .post(portal + `/project/largeScreen/v1/cityBrandDetailsById/${id}`)
      .then(res => {
        cb(res.data)
      })
  },
  // 中央文件对接落实情况列表查询
  getDockedFileData(data, cb) {
    req
      .post(portal + `/project/largeScreen/v1/documentsConsideredDetails`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 中央文件对接落实情况列表查询
  getDockedFileDetails(id, cb) {
    req
      .post(portal + `/project/largeScreen/v1/documentsConsideredById/${id}`)
      .then(res => {
        cb(res.data)
      })
  },
  // 加快实施一批报表详情数据查询
  getAccelerateImplementationDetails(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/speedUpBatchDetails?year=${data.year}&month=${data.month}&projectCategory=${data.projectCategory}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 根据项目id查询量化目标折线图数据
  getProjectLineChartData(data, cb) {
    req
      .post(
        portal +
          `/project/largeScreen/v1/indexCompleteRateChart?year=${data.year}&month=${data.month}&projectId=${data.projectId}`
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 成效晾晒excel导出
  downloadEffect(data, cb) {
    req
      .downloadPostCopy(
        portal + `/project/largeScreen/v1/cityBrandReformExport`,
        data
      )
      .then(res => {
        cb(res)
      })
  },
  // 改革需求excel导出
  downloadReform(data, cb) {
    req
      .downloadPostCopy(
        portal + `/project/largeScreen/v1/demandAnalysisLibraryExport`,
        data
      )
      .then(res => {
        cb(res)
      })
  },
  // 市级试点excel导出
  downloadMunicipalPilot(data, cb) {
    req
      .downloadPostCopy(
        portal + `/project/largeScreen/v1/cityPilotManagementExport`,
        data
      )
      .then(res => {
        cb(res)
      })
  },
  // 改革情况一览表导出
  downloadListOfReforms(data, cb) {
    req
      .downloadPostCopy(
        portal + `/bizCountyReformSituationFill/v1/export`,
        data
      )
      .then(res => {
        cb(res)
      })
  },

  // 改革情况一览表导出 列表
  downloadListSituation(data, cb) {
    req
      .downloadPostCopy(
        portal + `/county/largeScreen/v1/situation/exportBase`,
        data
      )
      .then(res => {
        cb(res)
      })
  },

  // 改革情况一览表导出 列表
  downloadListSituationDetail(data, cb) {
    req
      .downloadPostCopy(
        portal + `/county/largeScreen/v1/situation/exportData`,
        data
      )
      .then(res => {
        cb(res)
      })
  },

  // 加快实施一批月度进展查看详情
  getDetailsByType(data, cb) {
    let {year, month, projectId, planType, status} = data
    req
      .post(
        portal +
          `/project/largeScreen/v1/speedUpBatchList?year=${year}&month=${month}&projectId=${projectId}&planType=${planType}&status=${status}`
      )
      .then(res => {
        cb(res)
      })
  },

  // 六届全会
  getSixMeetingTableData(data, cb) {
    req
      .post(portal + `/project/largeScreen/v1/meetMunicipalList`, data)
      .then(res => {
        cb(res.data)
      })
  },
  getSixMeetingDeatils(id, cb) {
    req
      .post(portal + `/project/largeScreen/v1/meetMunicipal/${id}`)
      .then(res => {
        cb(res.data)
      })
  },

  // 改革情况一览表  区县
  getReformSituationData(data, cb) {
    req
      .post(portal + `/county/largeScreen/v1/countyQueryPage`, data)
      .then(res => {
        cb(res.data)
      })
  },

  // 改革情况一览表  下砖
  getReformSituationRunInHole(data, cb) {
    req
      .post(portal + `/county/largeScreen/v1/situation/index`, data)
      .then(res => {
        cb(res.data)
      })
  },

  // 改革情况一览表  市级
  getReformSituationCityData(data, cb) {
    req
      // .post(portal + `/municipal/largeScreen/v1/queryLargeScree`, data)
      .post(portal + `/project/largeScreen/v1/municipalSituation`, data)
      .then(res => {
        cb(res.data)
      })
  },

  // 改革情况一览表  文件查询
  getReformSituationFile(data, cb) {
    req
      .get(portal + `/file/v1/getFiles?id=${data.id}&code=${data.code}`)
      .then(res => {
        cb(res.data)
      })
  },

  // 六届六次全会-导出
  meetMunicipalExport(data, cb) {
    req
      .downloadPostCopy(
        portal + `/project/largeScreen/v1/meetMunicipal/export`,
        data
      )
      .then(res => {
        cb(res)
      })
  }
}

