import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    // 重点关注
    getTarget(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/county/largeScreen/v1/importantIndex?quarter=${data.quarter}&year=${data.year}`).then(res => {
                resolve(res.data)
            }).catch(err => {
                reject(err)
            })
        })
    },
    getBrandDetail(data, reqData) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/county/largeScreen/v1/brandReformDetails?quarter=${data.quarter}&year=${data.year}&unitCode=${data.unitCode}`, reqData).then(res => {
                console.log(res.data, "res.data)")
                resolve(res.data)
            }).catch(err => {
                reject(err)
            })
        })
    },
    exportLedgerDetail(data) {
        return new Promise((resolve, reject) => {
            req.request({
                method: 'post',
                data,
                url: portal + `/county/largeScreen/v1/pilotLedgerDetailExport`,
                responseType: 'blob'
            }).then(res => {
                console.log(res.data, "res.data)")
                resolve(res.data)
            }).catch(err => {
                reject(err)
            })
        })
    },
    // --------------------
    // 区县改革动态
    getNews(data, cb) {
        req.post(portal + `/fill/bizWorkNews/v1/queryCode`, data).then(res => {
            cb(res.data)
        })
    },
    // 指数排行榜
    getIndex(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/indexRank',
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 推广经验
    getBroad(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/citywidePromotionRank',
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 一本账
    getBookAccount(data, cb) {
        req.post(portal + '/county/largeScreen/v1/cityPromotionDetail', data).then(res => {
            cb(res.data)
        })
    },
    // 品牌榜
    getBrand(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/brandReform',
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 改革试点
    getPilotReform(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/pilotReform',
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 地图
    getGisData(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/gisIndex',
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 需求热力榜
    getDemandHeatList(data, cb) {
        console.log(data);
        let { year, month } = data
        req.post(portal + `/project/largeScreen/v1/demandHeatList?year=${year}&month=${month}`).then(res => {
            cb(res.data)
        })
    },
    // getDemandHeatList(data, cb) {
    //     req.request({
    //         method: 'post',
    //         url: portal + '/county/largeScreen/v1/demandHeatList',
    //         data,
    //         headers
    //     }).then(res => {
    //         cb(res.data)
    //     })
    // },
    // 需求清单
    getDemandList(data, cb) {
        req.post(portal + '/project/largeScreen/v1/demandDetailList', data).then(res => {
            cb(res.data)
        })
    },
    // getDemandList(data, cb) {
    //     req.post(portal + '/county/largeScreen/v1/demandDetailList', data).then(res => {
    //         cb(res.data)
    //     })
    // },
    // 获取文件列表
    getFiles(data, cb) {
        req.post(portal + '/file/v1/list', data).then(res => {
            cb(res.data)
        })
    },
    // 成果
    getPilotResultDetail(data, cb) {
        req.post(portal + '/county/largeScreen/v1/pilotResultDetail', data).then(res => {
            cb(res.data)
        })
    },
    //试点台账
    getPilotLedger(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/pilotLedger',
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 主驾驶舱试点台帐
    getPilotLedgerDetail_(data, cb) {
        req.post(portal + '/county/largeScreen/v1/pilotLedgerDetail_spc', data).then(res => {
            cb(res.data)
        })
    },
    //试点台账详情
    getPilotLedgerDetail(data, cb) {
        req.post(portal + '/county/largeScreen/v1/pilotLedgerDetail', data).then(res => {
            cb(res.data)
        })
    },
    //试点台账区县详情
    pilotPushDetailforUnit(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/pilotPushDetailforUnit',
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 区县报表详情
    statementDetail(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/statementDetail',
            data,
            headers,
        }).then(res => {
            cb(res.data)
        })
    },
    // 区县报表导出
    exportReport(data, isShow, cb) {
        req.request({
            method: 'post',
            url: portal + `/county/largeScreen/v1/statementDetailExport?isShow=${isShow}`,
            data,
            headers,
            responseType: 'blob'
        }).then(res => {
            cb(res.data)
        })
    },
    // 满意度报告
    satisfactionFile(data, cb) {
        req.request({
            method: 'post',
            url: portal + '/county/largeScreen/v1/currentStatementFile',
            data,
            headers,
        }).then(res => {
            cb(res.data)
        })
    },
    // 根据文件ID预览文件
    previewFile(data) {
        return new Promise((resolve, reject) => {
            req.request({
                method: 'get',
                url: portal + '/file/onlinePreviewController/v1/getFileById_' + data,
                headers: {
                    "Content-Type": 'application/json'
                },
                responseType: 'blob'
            }).then(res => {
                resolve(res.data)
            }).catch(err => {
                reject(err)
            })
        })
    },
    // 二级问题破解详情
    problemSolvingDetail(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + '/county/largeScreen/v1/problemSolvingDetail_sec', data
            ).then(res => {
                resolve(res.data)
            }).catch(err => {
                reject(err)
            })
        })
    },
    // 二级需求详情
    reformDemandDetails(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + '/county/largeScreen/v1/reformDemandDetails_sec', data
            ).then(res => {
                resolve(res.data)
            }).catch(err => {
                reject(err)
            })
        })
    },
    // 二级需求清单
    reformDemandDetailList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + '/county/largeScreen/v1/reformDemandDetailList_sec', data
            ).then(res => {
                resolve(res.data)
            }).catch(err => {
                reject(err)
            })
        })
    },
    // 二级试点台账
    pilotLedgerDetailSec(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + '/county/largeScreen/v1/pilotLedgerDetail_sec', data
            ).then(res => {
                resolve(res.data)
            }).catch(err => {
                reject(err)
            })
        })
    },
    // 作战图总览
    getBattleChartOverview(data, cb) {
        let { year, month, projectId } = data
        req.post(portal + `/project/largeScreen/v1/monthPlanNumDetails?year=${year}&month=${month}&projectId=${projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 下拉框查询所有项目
    getProjectAll(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/queryAll`, data).then(res => {
            cb(res.data)
        })
    },
    // 分页查询项目月度计划及推进情况
    getPagingQuery(data, cb) {
        req.post(portal + `/project/largeScreen/v1/monthPlanPageList`, data).then(res => {
            cb(res.data)
        })
    },
    // 导出作战图总览分页查询月度计划列表
    exportMonthList(data, cb) {
        req.downloadPostCopy(portal + `/project/largeScreen/v1/exportMonthPlanList`, data).then(res => {
            console.log(res);
            cb(res.data)
        })
    },
    // 指标库弹窗
    // 进入指标库查询列表
    enterGetDataOld(data, cb) {
        req.post(portal + `/project/largeScreen/v1/overviewComplianceInfo?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    enterGetData(data, cb) {
        req.post(portal + `/project/largeScreen/v1/indexDetails?year=${data.year}&month=${data.month}&projectId=${data.projectId}&projectCategory=${data.projectCategory}`).then(res => {
            cb(res.data)
        })
    },
    // 核心指标导出c
    coreIndexDerivation(data, cb) {
        req.downloadPostCopy(portal + `/project/largeScreen/v1/indexYearPlanDetailsDataExport?year=${data.year}&month=${data.month}`, data).then(res => {
            cb(res.data)
        })
    },
    // 满意度数据时间查询
    satisfactionRealityDate(data, cb) {
        req.post(portal + `/county/largeScreen/v1/satisfactionRealityDate?year=${data.year}&quarter=${data.quarter}`).then(res => {
            cb(res.data)
        })
    },
    // 数字重庆名录库----一件事
    digitalCQOne(data, cb) {
        req.post(portal + `/fill/bizDigitalOneThing/v1/queryByPage`, data).then(res => {
            cb(res.data)
        })
    },
    // 数字重庆名录库----三张清单
    digitalCQTwo(data, cb) {
        req.post(portal + `/fill/bizDigitalThreeLists/v1/queryByPage`, data).then(res => {
            cb(res.data)
        })
    },
    // 数字重庆名录库----上线应用
    digitalCQThree(data, cb) {
        req.post(portal + `/fill/bizDigitalOnLineApplication/v1/queryByPage`, data).then(res => {
            cb(res.data)
        })
    },
    // 数字重庆名录库----特色应用
    digitalCQFour(data, cb) {
        req.post(portal + `/fill/bizDigitalShareApplication/v1/queryByPage`, data).then(res => {
            cb(res.data)
        })
    },
    // 数字重庆----一件事全量库
    digitalCQOneAll(data, cb) {
        req.post(portal + `/fill/bizDigitalOneThing/v1/queryByPageAll`, data).then(res => {
            cb(res.data)
        })
    },
    // 数字重庆----一件事全量库导出
    digitalCQOneAllExport(data, cb) {
        req.downloadPostCopy(portal + `/fill/bizDigitalOneThing/v1/exportList`, data).then(res => {
            cb(res.data)
        })
    },
    // 满意度报告查询
    getSatisfaction(data, cb) {
        let { quarter, year } = data
        req.post(portal + `/county/largeScreen/v1/satisfaction_files?year=${year}&quarter=${quarter}`,).then(res => {
            cb(res.data)
        })
    },
    // 品牌显示度台账导出 
    exportBrandExcel(data, reqData, cb) {
        req.downloadPostCopy(portal + `/county/largeScreen/v1/brandReformDetailsExport?quarter=${data.quarter}&year=${data.year}&unitCode=${data.unitCode}`, reqData).then(res => {
            cb(res.data)
        })
    },
    //新增试点折线图
    getNewPilotChartData(data, cb) {
        let { quarter, year } = data
        req.post(portal + `/county/largeScreen/v1/pilotReformAdd?year=${year}&quarter=${quarter}`,).then(res => {
            cb(res.data)
        })
    },
    // 2024年品牌榜
    getNewBrandBarData(data, cb) {
        let { quarter, year } = data
        req.post(portal + `/county/largeScreen/v1/brandReformNation?year=${year}&quarter=${quarter}`,).then(res => {
            cb(res.data)
        })
    },
}