import req from "@/request.js";

const portal = window.context.portal;
export default {
    //分页
    pagingQuery(data, cb) {
        req.post(portal + `/fill/bizProfileInfo/v1/query`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 改革资料分页
    pagingList(data, cb) {
        req.post(portal + `/fill/bizProfileInfo/v1/list`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 保存或修改
    saveOrUpdateFile(data, cb) {
        req.post(portal + `/fill/bizProfileInfo/v1/`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 根据id查询详情
    getDetailsById(id, cb) {
        req.get(portal + `/fill/bizProfileInfo/v1/${id}`).then(rep => {
            cb(rep.data);
        });
    },
    // 根据id发布或撤回
    publishById(data, cb) {
        req.post(portal + `/fill/bizProfileInfo/v1/updateById`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 根据id删除
    deleteById(ids,cb) {
        req.post(portal + `/fill/bizProfileInfo/v1/deleteByIds?ids=${ids}`).then(rep => {
            cb(rep.data);
        });
    },
}
