import req from '@/request.js'
import qs from 'qs'
const portal = window.context.portal
export default {
  // 部门 改革办 审核列表
  departmentAudit(data,isAffirm) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizMunicipalReformSituation/v1/queryPage?isAffirm=${isAffirm}`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  // 专项小组 审核列表
  specializedGroup(data,isAffirm) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizMunicipalReformSituation/v1/queryByGroupPage?isAffirm=${isAffirm}`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  // 修改审核状态
  updateMunStatus(data, cb) {
    let approvalComments = data.approvalComments !== '' && data.approvalComments !== undefined?data.approvalComments:''
    req.put(portal + `/bizMunicipalReformSituation/v1/updateStatus?id=${data.id}&status=${data.status}&approvalComments=${approvalComments}`).then(res => {
      cb(res.data)
    })
  },
}
