import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default { 
    // 分页查询
    queryPageFillList(data, status, cb) {
        req.post(portal + `/majorProjects/bizPilotProjectFill/v1/queryPageFillList?flowType=1&isAffirm=${status}`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据项目ID获取初始化目标信息
    getDefaultQuaObj(data, cb) {
        req.post(portal + '/majorProjects/pilotQuantitativeObjectivesPush/v1/examineInit', data).then(res => {
            cb(res.data)
        })
    },
    // 保存为草稿
    save(data, cb) {
        req.put(portal + '/majorProjects/pilotQuantitativeObjectivesPush/v1/quantitativeObjectivesPushSave', data).then(res => {
            cb(res.data)
        })
    },
    // 保存并上报
    saveAndSubmit(data, cb) {
        req.put(portal + '/majorProjects/pilotQuantitativeObjectivesPush/v1/quantitativeObjectivesPushSaveSaveAndCommit', data).then(res => {
            cb(res.data)
        })
    },
    // 获取待审核数据
    getAuditData(id, cb) {
        req.get(portal + '/majorProjects/pilotQuantitativeObjectivesPush/v1/getDetails?id=' + id).then(res => {
            cb(res.data)
        })
    },
    // 根据项目ID获取历史填报信息
    getHistoryData(data, cb) {
        req.post(portal + '/majorProjects/pilotQuantitativeObjectivesPush/v1/getHistoryDetails', data).then(res => {
            cb(res.data)
        })
    },
    // 审核
    verify(data, cb) {
        req.post(portal + '/majorProjects/pilotQuantitativeObjectivesPush/v1/quantitativeObjectivesPushExamine', data).then(res => {
            cb(res.data)
        })
    },
    // 上报
    commit(id, cb) {
        req.get(portal + '/majorProjects/pilotQuantitativeObjectivesPush/v1/quantitativeObjectivesPushCommit?id=' + id).then(res => {
            cb(res.data)
        })
    },
    // 判断当前月是否更新审核通过
    isMonthApprove(data, cb) {
        req.post(portal + `/majorProjects/pilotQuantitativeObjectivesPush/v1/isPassUpdate?projectId=${data.projectId}&fillDate=${data.fillDate}`).then(res => {
            cb(res.data)
        })
    },

    // 专项小组审核查询
    getGroupAuditData(data, cb) {
        req.post(portal + `/majorProjects/bizPilotProjectFill/v1/queryPageFillGroup?flowType=1`, data).then(res => {
            cb(res.data)
        })
    }
}